/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.AppPlatformException;
import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.ConferenceMember;
import com.bandwidth.sdk.model.Gender;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.SentenceLocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Conference
extends ResourceBase {
    public static Conference getConference(String id) throws Exception {
        BandwidthClient client = BandwidthClient.getInstance();
        return Conference.getConference(client, id);
    }

    public static Conference getConference(BandwidthClient client, String id) throws Exception {
        String conferencesUri = client.getUserResourceUri("conferences");
        String conferenceUri = StringUtils.join((Object[])new String[]{conferencesUri, id}, (char)'/');
        JSONObject jsonObject = Conference.toJSONObject(client.get(conferenceUri, null));
        return new Conference(client, jsonObject);
    }

    public static Conference createConference(Map<String, Object> params) throws Exception {
        return Conference.createConference(BandwidthClient.getInstance(), params);
    }

    public static Conference createConference(BandwidthClient client, Map<String, Object> params) throws Exception {
        String conferencesUri = client.getUserResourceUri("conferences");
        RestResponse response = client.post(conferencesUri, params);
        String id = response.getLocation().substring(client.getPath(conferencesUri).length() + 1);
        return Conference.getConference(client, id);
    }

    public Conference(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    protected String getUri() {
        return this.client.getUserResourceInstanceUri("conferences", this.getId());
    }

    public String getFrom() {
        return this.getPropertyAsString("from");
    }

    public String getCallbackUrl() {
        return this.getPropertyAsString("callbackUrl");
    }

    public String getFallbackUrl() {
        return this.getPropertyAsString("fallbackUrl");
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public Long getActiveMembers() {
        return this.getPropertyAsLong("activeMembers");
    }

    public Long getCallbackTimeout() {
        return this.getPropertyAsLong("callbackTimeout");
    }

    public Date getCompletedTime() {
        return this.getPropertyAsDate("completedTime");
    }

    public Date getCreatedTime() {
        return this.getPropertyAsDate("createdTime");
    }

    public void complete() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", "completed");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = Conference.toJSONObject(this.client.get(uri, null));
        this.updateProperties(jsonObject);
    }

    public void mute() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mute", String.valueOf(true));
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = Conference.toJSONObject(this.client.get(uri, null));
        this.updateProperties(jsonObject);
    }

    public List<ConferenceMember> getMembers() throws Exception {
        String membersPath = StringUtils.join((Object[])new String[]{this.getUri(), "members"}, (char)'/');
        JSONArray array = Conference.toJSONArray(this.client.get(membersPath, null));
        ArrayList<ConferenceMember> members = new ArrayList<ConferenceMember>();
        for (Object obj : array) {
            members.add(new ConferenceMember(this.client, (JSONObject)obj));
        }
        return members;
    }

    public ConferenceAudioBuilder conferenceAudioBuilder() {
        return new ConferenceAudioBuilder();
    }

    private void createConferenceAudio(Map<String, Object> params) throws IOException, AppPlatformException {
        String audioPath = StringUtils.join((Object[])new String[]{this.getUri(), "audio"}, (char)'/');
        this.client.post(audioPath, params);
    }

    public String toString() {
        return "Conference{id='" + this.getId() + '\'' + ", from='" + this.getFrom() + '\'' + ", callbackUrl='" + this.getCallbackUrl() + '\'' + ", fallbackUrl='" + this.getFallbackUrl() + '\'' + ", state=" + this.getState() + ", activeMembers=" + this.getActiveMembers() + ", callbackTimeout=" + this.getCallbackTimeout() + ", completedTime=" + this.getCompletedTime() + ", createdTime=" + this.getCreatedTime() + '}';
    }

    public class ConferenceAudioBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public ConferenceAudioBuilder fileUrl(String fileUrl) {
            this.params.put("fileUrl", fileUrl);
            return this;
        }

        public ConferenceAudioBuilder sentence(String sentence) {
            this.params.put("sentence", sentence);
            return this;
        }

        public ConferenceAudioBuilder gender(Gender gender) {
            this.params.put("gender", gender.name());
            return this;
        }

        public ConferenceAudioBuilder locale(SentenceLocale locale) {
            this.params.put("locale", locale.restValue);
            return this;
        }

        public ConferenceAudioBuilder voice(String voice) {
            this.params.put("voice", voice);
            return this;
        }

        public void create() throws IOException, AppPlatformException {
            Conference.this.createConferenceAudio(this.params);
        }
    }
}

