/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.AppPlatformException;
import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.ResourceBase;
import java.io.IOException;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EndpointToken
extends ResourceBase {
    public EndpointToken(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    public static JSONObject toJSONObject(RestResponse response) throws ParseException {
        return (JSONObject)new JSONParser().parse(response.getResponseText());
    }

    public static EndpointToken create(BandwidthClient client, String domainId, String endpointId) throws AppPlatformException, ParseException, IOException {
        assert (client != null && domainId != null && endpointId != null);
        return EndpointToken.createToken(client, domainId, endpointId, null);
    }

    public static EndpointToken create(String domainId, String endpointId) throws AppPlatformException, ParseException, IOException {
        assert (domainId != null && endpointId != null);
        return EndpointToken.createToken(null, domainId, endpointId, null);
    }

    public static EndpointToken create(BandwidthClient client, String domainId, String endpointId, Long expires) throws AppPlatformException, ParseException, IOException {
        assert (client != null && domainId != null && endpointId != null && expires != null && expires > 0L);
        return EndpointToken.createToken(client, domainId, endpointId, expires);
    }

    public static EndpointToken create(String domainId, String endpointId, Long expires) throws AppPlatformException, ParseException, IOException {
        assert (domainId != null && endpointId != null && expires != null && expires > 0L);
        return EndpointToken.createToken(null, domainId, endpointId, expires);
    }

    private static EndpointToken createToken(BandwidthClient client, String domainId, String endpointId, Long expires) throws AppPlatformException, ParseException, IOException {
        BandwidthClient bandwidthClient = client;
        if (bandwidthClient == null) {
            bandwidthClient = BandwidthClient.getInstance();
        }
        RestResponse response = null;
        String endpointTokenUri = String.format(bandwidthClient.getUserResourceUri("domains/%s/endpoints/%s/tokens"), domainId, endpointId);
        if (expires == null) {
            response = bandwidthClient.postJson(endpointTokenUri, "");
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("expires", expires);
            response = bandwidthClient.post(endpointTokenUri, params);
        }
        JSONObject callObj = EndpointToken.toJSONObject(response);
        return new EndpointToken(bandwidthClient, callObj);
    }

    public static void delete(BandwidthClient client, String domainId, String endpointId, String token) throws AppPlatformException, ParseException, IOException {
        assert (client != null && domainId != null && endpointId != null && endpointId != null);
        EndpointToken.deleteToken(client, domainId, endpointId, token);
    }

    public static void delete(String domainId, String endpointId, String token) throws AppPlatformException, ParseException, IOException {
        assert (domainId != null && endpointId != null && endpointId != null);
        EndpointToken.deleteToken(null, domainId, endpointId, token);
    }

    private static void deleteToken(BandwidthClient client, String domainId, String endpointId, String token) throws AppPlatformException, ParseException, IOException {
        BandwidthClient bandwidthClient = client;
        if (bandwidthClient == null) {
            bandwidthClient = BandwidthClient.getInstance();
        }
        String endpointTokenUri = String.format(bandwidthClient.getUserResourceUri("domains/%s/endpoints/%s/tokens/%s"), domainId, endpointId, token);
        bandwidthClient.delete(endpointTokenUri);
    }

    public Long getExpires() {
        return this.getPropertyAsLong("expires");
    }

    public String getToken() {
        return this.getPropertyAsString("token");
    }
}

