/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.MediaFile;
import com.bandwidth.sdk.model.ReceiptRequest;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.ResourceList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class Message
extends ResourceBase {
    public static Message get(String id) throws Exception {
        return Message.get(BandwidthClient.getInstance(), id);
    }

    public static Message get(BandwidthClient client, String id) throws Exception {
        String messagesUri = client.getUserResourceInstanceUri("messages", id);
        JSONObject jsonObject = Message.toJSONObject(client.get(messagesUri, null));
        return new Message(client, jsonObject);
    }

    public static ResourceList<Message> list() throws Exception {
        return Message.list(0, 25);
    }

    public static ResourceList<Message> list(int page, int size) throws Exception {
        return Message.list(BandwidthClient.getInstance(), page, size);
    }

    public static ResourceList<Message> list(BandwidthClient client, int page, int size) throws Exception {
        String messageUri = client.getUserResourceUri("messages");
        ResourceList<Message> messages = new ResourceList<Message>(page, size, messageUri, Message.class);
        messages.setClient(client);
        messages.initialize();
        return messages;
    }

    public static Message create(String to, String from, String text) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("to", to);
        params.put("from", from);
        params.put("text", text);
        return Message.create(params);
    }

    public static Message create(String to, String from, String text, ReceiptRequest receiptRequest) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("to", to);
        params.put("from", from);
        params.put("text", text);
        if (receiptRequest != null) {
            params.put("receiptRequested", receiptRequest.toString());
        } else {
            params.put("receiptRequested", ReceiptRequest.NONE.toString());
        }
        return Message.create(params);
    }

    public static Message create(String to, String from, String text, String media) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("to", to);
        params.put("from", from);
        params.put("text", text);
        params.put("media", media);
        return Message.create(params);
    }

    public static Message create(String to, String from, String text, MediaFile media) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("to", to);
        params.put("from", from);
        params.put("text", text);
        params.put("media", media.getContent());
        return Message.create(params);
    }

    public static Message create(Map<String, Object> params) throws Exception {
        return Message.create(BandwidthClient.getInstance(), params);
    }

    public static Message create(BandwidthClient client, Map<String, Object> params) throws Exception {
        String messageUri = client.getUserResourceUri("messages");
        RestResponse response = client.post(messageUri, params);
        String messageId = response.getLocation().substring(client.getPath(messageUri).length() + 1);
        return Message.get(client, messageId);
    }

    public Message(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    protected String getUri() {
        return this.client.getUserResourceInstanceUri("messages", this.getId());
    }

    public String getMessageId() {
        return this.getPropertyAsString("messageId");
    }

    public String getFrom() {
        return this.getPropertyAsString("from");
    }

    public String getTo() {
        return this.getPropertyAsString("to");
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public String getDirection() {
        return this.getPropertyAsString("direction");
    }

    public String getCallbackUrl() {
        return this.getPropertyAsString("callbackUrl");
    }

    public String getFallbackUrl() {
        return this.getPropertyAsString("fallbackUrl");
    }

    public String getText() {
        return this.getPropertyAsString("text");
    }

    public Date getTime() {
        return this.getPropertyAsDate("time");
    }

    public Long getCallbackTimeout() {
        return this.getPropertyAsLong("callbackTimeout");
    }

    public String getReceiptRequested() {
        return this.getPropertyAsString("receiptRequested");
    }

    public String toString() {
        return "Message{id='" + this.getId() + '\'' + ", messageId='" + this.getMessageId() + '\'' + ", from='" + this.getFrom() + '\'' + ", to='" + this.getTo() + '\'' + ", state='" + this.getState() + '\'' + ", direction='" + this.getDirection() + '\'' + ", callbackUrl='" + this.getCallbackUrl() + '\'' + ", fallbackUrl='" + this.getFallbackUrl() + '\'' + ", text='" + this.getText() + '\'' + ", time=" + this.getTime() + ", callbackTimeout=" + this.getCallbackTimeout() + ", receiptRequested=" + this.getReceiptRequested() + '}';
    }
}

