/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model.events;

import com.bandwidth.sdk.AppPlatformException;
import com.bandwidth.sdk.model.ModelBase;
import com.bandwidth.sdk.model.events.AnswerEvent;
import com.bandwidth.sdk.model.events.ConferenceEvent;
import com.bandwidth.sdk.model.events.ConferenceMemberEvent;
import com.bandwidth.sdk.model.events.ConferencePlaybackEvent;
import com.bandwidth.sdk.model.events.ConferenceSpeakEvent;
import com.bandwidth.sdk.model.events.DtmfEvent;
import com.bandwidth.sdk.model.events.Event;
import com.bandwidth.sdk.model.events.EventType;
import com.bandwidth.sdk.model.events.GatherEvent;
import com.bandwidth.sdk.model.events.HangupEvent;
import com.bandwidth.sdk.model.events.IncomingCallEvent;
import com.bandwidth.sdk.model.events.PlaybackEvent;
import com.bandwidth.sdk.model.events.RecordingEvent;
import com.bandwidth.sdk.model.events.RejectEvent;
import com.bandwidth.sdk.model.events.SmsEvent;
import com.bandwidth.sdk.model.events.SpeakEvent;
import com.bandwidth.sdk.model.events.TimeoutEvent;
import com.bandwidth.sdk.model.events.TranscriptionEvent;
import com.bandwidth.sdk.model.events.Visitor;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EventBase
extends ModelBase
implements Event {
    protected EventType eventType;

    public static Event createEventFromString(String in) throws AppPlatformException {
        JSONObject jsonObj = null;
        try {
            jsonObj = (JSONObject)new JSONParser().parse(in);
        }
        catch (ParseException e) {
            throw new AppPlatformException(e);
        }
        EventType eventType = EventType.getEnum((String)jsonObj.get((Object)"eventType"));
        EventBase event = null;
        switch (eventType) {
            case INCOMINGCALL: {
                event = new IncomingCallEvent(jsonObj);
                break;
            }
            case ANSWER: {
                event = new AnswerEvent(jsonObj);
                break;
            }
            case SPEAK: {
                event = new SpeakEvent(jsonObj);
                break;
            }
            case PLAYBACK: {
                event = new PlaybackEvent(jsonObj);
                break;
            }
            case GATHER: {
                event = new GatherEvent(jsonObj);
                break;
            }
            case HANGUP: {
                event = new HangupEvent(jsonObj);
                break;
            }
            case DTMF: {
                event = new DtmfEvent(jsonObj);
                break;
            }
            case REJECT: {
                event = new RejectEvent(jsonObj);
                break;
            }
            case RECORDING: {
                event = new RecordingEvent(jsonObj);
                break;
            }
            case TRANSCRIPTION: {
                event = new TranscriptionEvent(jsonObj);
                break;
            }
            case SMS: {
                event = new SmsEvent(jsonObj);
                break;
            }
            case TIMEOUT: {
                event = new TimeoutEvent(jsonObj);
                break;
            }
            case CONFERENCE: {
                event = new ConferenceEvent(jsonObj);
                break;
            }
            case CONFERENCE_MEMBER: {
                event = new ConferenceMemberEvent(jsonObj);
                break;
            }
            case CONFERENCE_PLAYBACK: {
                event = new ConferencePlaybackEvent(jsonObj);
                break;
            }
            case CONFERENCE_SPEAK: {
                event = new ConferenceSpeakEvent(jsonObj);
                break;
            }
            default: {
                event = new EventBase(jsonObj);
            }
        }
        return event;
    }

    @Override
    public void execute(Visitor visitor) {
        visitor.processEvent(this);
    }

    public EventBase(JSONObject json) {
        this.updateProperties(json);
        this.eventType = EventType.getEnum((String)json.get((Object)"eventType"));
    }

    public String getId() {
        return this.getPropertyAsString("id");
    }

    public String getTime() {
        return this.getProperty("time");
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    public String getTag() {
        return this.getPropertyAsString("tag");
    }

    @Override
    public Map<String, Object> toMap() {
        return super.toMap();
    }

    @Override
    public String getProperty(String property) {
        return this.getPropertyAsString(property);
    }

    @Override
    public void setProperty(String name, String value) {
        this.putProperty(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Event");
        sb.append(this.properties);
        return sb.toString();
    }
}

