/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.xml.elements;

import com.bandwidth.sdk.exception.XMLInvalidAttributeException;
import com.bandwidth.sdk.xml.elements.Elements;
import com.bandwidth.sdk.xml.elements.PhoneNumber;
import com.bandwidth.sdk.xml.elements.PlayAudio;
import com.bandwidth.sdk.xml.elements.SpeakSentence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Transfer")
public class Transfer
implements Elements {
    private static final int MAX_PHONE_NUMBERS = 7;
    protected String transferTo;
    protected String transferCallerId;
    protected Integer callTimeout;
    protected Boolean recordingEnabled;
    protected String recordingCallbackUrl;
    protected String terminatingDigits;
    protected Integer maxDuration;
    protected String fileFormat;
    protected Boolean transcribe;
    protected String transcribeCallbackUrl;
    protected List<PhoneNumber> phoneNumberList;
    protected SpeakSentence speakSentence;
    protected PlayAudio playAudio;

    public Transfer() {
    }

    public Transfer(String transferCallerId) throws XMLInvalidAttributeException {
        this.setTransferCallerId(transferCallerId);
    }

    public Transfer(String transferTo, String transferCallerId) throws XMLInvalidAttributeException {
        this.setTransferTo(transferTo);
        this.setTransferCallerId(transferCallerId);
    }

    public Transfer(String transferTo, String transferCallerId, SpeakSentence speakSentence) throws XMLInvalidAttributeException {
        this.setTransferTo(transferTo);
        this.setTransferCallerId(transferCallerId);
        this.setSpeakSentence(speakSentence);
    }

    public Transfer(String transferTo, String transferCallerId, PlayAudio playAudio) throws XMLInvalidAttributeException {
        this.setTransferTo(transferTo);
        this.setTransferCallerId(transferCallerId);
        this.setPlayAudio(playAudio);
    }

    @XmlAttribute(name="transferCallerId", required=true)
    public String getTransferCallerId() {
        return this.transferCallerId;
    }

    public void setTransferCallerId(String transferCallerId) throws XMLInvalidAttributeException {
        if (transferCallerId == null || transferCallerId.trim().isEmpty()) {
            throw new XMLInvalidAttributeException("transferCallerId mustn't not be empty or null");
        }
        this.transferCallerId = transferCallerId;
    }

    @XmlAttribute(name="transferTo", required=true)
    public String getTransferTo() {
        return this.transferTo;
    }

    public void setTransferTo(String transferTo) throws XMLInvalidAttributeException {
        if ((this.phoneNumberList == null || this.phoneNumberList.isEmpty()) && (transferTo == null || transferTo.trim().isEmpty())) {
            throw new XMLInvalidAttributeException("transferTo mustn't not be empty or null");
        }
        this.transferTo = transferTo;
    }

    @XmlElement(name="PhoneNumber")
    public List<PhoneNumber> getPhoneNumberList() {
        if (this.phoneNumberList == null || this.phoneNumberList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.phoneNumberList;
    }

    public void setPhoneNumberList(List<PhoneNumber> phoneNumberList) throws XMLInvalidAttributeException {
        if (phoneNumberList != null && phoneNumberList.size() > 7) {
            throw new XMLInvalidAttributeException(String.format("Transfer can only hold %s phone numbers", 7));
        }
        this.phoneNumberList = phoneNumberList;
    }

    public void addPhoneNumber(String phoneNumber) throws XMLInvalidAttributeException {
        if (this.phoneNumberList == null) {
            this.phoneNumberList = new ArrayList<PhoneNumber>();
        }
        if (this.phoneNumberList.size() == 7) {
            throw new XMLInvalidAttributeException(String.format("Transfer can only hold %s phone numbers", 7));
        }
        this.phoneNumberList.add(new PhoneNumber(phoneNumber));
    }

    @XmlAttribute(name="callTimeout")
    public Integer getCallTimeout() {
        return this.callTimeout;
    }

    public void setCallTimeout(Integer callTimeout) throws XMLInvalidAttributeException {
        if (callTimeout == null || callTimeout < 0) {
            throw new XMLInvalidAttributeException("callTimeout mustn't not be null or less than zero");
        }
        this.callTimeout = callTimeout;
    }

    @XmlAttribute(name="recordingEnabled")
    public Boolean getRecordingEnabled() {
        return this.recordingEnabled;
    }

    public void setRecordingEnabled(Boolean recordingEnabled) throws XMLInvalidAttributeException {
        if (recordingEnabled == null) {
            throw new XMLInvalidAttributeException("recordingEnabled mustn't not be null");
        }
        this.recordingEnabled = recordingEnabled;
    }

    @XmlAttribute(name="recordingCallbackUrl")
    public String getRecordingCallbackUrl() {
        return this.recordingCallbackUrl;
    }

    public void setRecordingCallbackUrl(String recordingCallbackUrl) throws XMLInvalidAttributeException {
        if (recordingCallbackUrl == null || recordingCallbackUrl.trim().isEmpty()) {
            throw new XMLInvalidAttributeException("recordingCallbackUrl mustn't not be empty or null");
        }
        this.recordingCallbackUrl = recordingCallbackUrl;
    }

    @XmlAttribute(name="terminatingDigits")
    public String getTerminatingDigits() {
        return this.terminatingDigits;
    }

    public void setTerminatingDigits(String terminatingDigits) throws XMLInvalidAttributeException {
        if (terminatingDigits == null || terminatingDigits.trim().isEmpty()) {
            throw new XMLInvalidAttributeException("terminatingDigits mustn't not be empty or null");
        }
        this.terminatingDigits = terminatingDigits;
    }

    @XmlAttribute(name="maxDuration")
    public Integer getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(Integer maxDuration) throws XMLInvalidAttributeException {
        if (maxDuration == null || maxDuration < 0) {
            throw new XMLInvalidAttributeException("maxDuration mustn't not be null or less than zero");
        }
        this.maxDuration = maxDuration;
    }

    @XmlAttribute(name="fileFormat")
    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) throws XMLInvalidAttributeException {
        if (fileFormat == null || fileFormat.trim().isEmpty()) {
            throw new XMLInvalidAttributeException("fileFormat mustn't not be empty or null");
        }
        this.fileFormat = fileFormat;
    }

    @XmlAttribute(name="transcribe")
    public Boolean getTranscribe() {
        return this.transcribe;
    }

    public void setTranscribe(Boolean transcribe) throws XMLInvalidAttributeException {
        if (transcribe == null) {
            throw new XMLInvalidAttributeException("transcribe mustn't not be null");
        }
        this.transcribe = transcribe;
    }

    @XmlAttribute(name="transcribeCallbackUrl")
    public String getTranscribeCallbackUrl() {
        return this.transcribeCallbackUrl;
    }

    public void setTranscribeCallbackUrl(String transcribeCallbackUrl) throws XMLInvalidAttributeException {
        if (transcribeCallbackUrl == null || transcribeCallbackUrl.trim().isEmpty()) {
            throw new XMLInvalidAttributeException("transcribeCallbackUrl mustn't not be empty or null");
        }
        this.transcribeCallbackUrl = transcribeCallbackUrl;
    }

    @XmlElement(name="SpeakSentence")
    public SpeakSentence getSpeakSentence() {
        return this.speakSentence;
    }

    public void setSpeakSentence(SpeakSentence speakSentence) {
        this.speakSentence = speakSentence;
    }

    @XmlElement(name="PlayAudio")
    public PlayAudio getPlayAudio() {
        return this.playAudio;
    }

    public void setPlayAudio(PlayAudio playAudio) {
        this.playAudio = playAudio;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Transfer{");
        sb.append("transferTo='").append(this.transferTo).append('\'');
        sb.append(", transferCallerId='").append(this.transferCallerId).append('\'');
        sb.append(", phoneNumberList='").append(this.phoneNumberList).append('\'');
        sb.append(", callTimeout='").append(this.callTimeout).append('\'');
        sb.append(", recordingEnabled='").append(this.recordingEnabled).append('\'');
        sb.append(", recordingCallbackUrl='").append(this.recordingCallbackUrl).append('\'');
        sb.append(", terminatingDigits='").append(this.terminatingDigits).append('\'');
        sb.append(", maxDuration='").append(this.maxDuration).append('\'');
        sb.append(", fileFormat='").append(this.fileFormat).append('\'');
        sb.append(", transcribe='").append(this.transcribe).append('\'');
        sb.append(", transcribeCallbackUrl='").append(this.transcribeCallbackUrl).append('\'');
        sb.append(", speakSentence=").append(this.speakSentence);
        sb.append(", playAudio=").append(this.playAudio);
        sb.append('}');
        return sb.toString();
    }
}

