/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk;

import com.bandwidth.sdk.Client;
import com.bandwidth.sdk.RestResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;

public class BandwidthClient
implements Client {
    protected static final String GET = "get";
    protected static final String POST = "post";
    protected static final String PUT = "put";
    protected static final String DELETE = "delete";
    protected String token;
    protected String secret;
    protected String apiVersion;
    protected String apiEndpoint;
    protected String usersUri;
    protected HttpClient httpClient;
    public static String BANDWIDTH_USER_ID = "BANDWIDTH_USER_ID";
    public static String BANDWIDTH_API_TOKEN = "BANDWIDTH_API_TOKEN";
    public static String BANDWIDTH_API_SECRET = "BANDWIDTH_API_SECRET";
    public static String BANDWIDTH_API_ENDPOINT = "BANDWIDTH_API_ENDPOINT";
    public static String BANDWIDTH_API_VERSION = "BANDWIDTH_API_VERSION";
    protected static BandwidthClient INSTANCE;

    public static BandwidthClient getInstance() {
        if (INSTANCE == null) {
            Map<String, String> env = System.getenv();
            String userId = env.get(BANDWIDTH_USER_ID);
            String apiToken = env.get(BANDWIDTH_API_TOKEN);
            String apiSecret = env.get(BANDWIDTH_API_SECRET);
            String apiEndpoint = env.get(BANDWIDTH_API_ENDPOINT);
            String apiVersion = env.get(BANDWIDTH_API_VERSION);
            INSTANCE = new BandwidthClient(userId, apiToken, apiSecret, apiEndpoint, apiVersion);
        }
        return INSTANCE;
    }

    public static BandwidthClient getInstance(String userId, String apiToken, String apiSecret) {
        if (INSTANCE == null) {
            INSTANCE = new BandwidthClient(userId, apiToken, apiSecret, null, null);
        }
        return INSTANCE;
    }

    protected BandwidthClient(String userId, String apiToken, String apiSecret, String apiEndpoint, String apiVersion) {
        this.usersUri = String.format("users/%s", userId);
        this.token = apiToken;
        this.secret = apiSecret;
        this.apiEndpoint = apiEndpoint;
        this.apiVersion = apiVersion;
        if (apiEndpoint == null || apiVersion == null) {
            this.apiEndpoint = "https://api.catapult.inetwork.com";
            this.apiVersion = "v1";
        }
        this.httpClient = new DefaultHttpClient();
    }

    public String getUserResourceUri(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        return StringUtils.join((Object[])new String[]{this.getUserUri(), path}, (String)"/");
    }

    public String getUserResourceInstanceUri(String path, String instanceId) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)instanceId)) {
            throw new IllegalArgumentException("Path and Instance Id cannot be null");
        }
        return this.getUserResourceUri(path) + "/" + instanceId;
    }

    public String getBaseResourceUri(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        return path + "/";
    }

    public String getPath(String uri) {
        Object[] parts = new String[]{this.apiEndpoint, this.apiVersion, uri};
        return StringUtils.join((Object[])parts, (char)'/');
    }

    public String getUserUri() {
        return this.usersUri;
    }

    public RestResponse post(String uri, Map<String, Object> params) throws IOException {
        return this.request(this.getPath(uri), POST, params);
    }

    @Override
    public RestResponse get(String uri, Map<String, Object> params) throws Exception {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, GET, params);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
        return response;
    }

    public RestResponse put(String uri, Map<String, Object> params) throws IOException {
        return this.request(this.getPath(uri), PUT, params);
    }

    public RestResponse delete(String uri) throws IOException {
        return this.request(this.getPath(uri), DELETE);
    }

    protected RestResponse request(String path, String method) throws IOException {
        return this.request(path, method, null);
    }

    protected RestResponse request(String path, String method, Map<String, Object> paramList) throws IOException {
        if (paramList == null) {
            paramList = Collections.emptyMap();
        }
        HttpUriRequest request = this.setupRequest(path, method, paramList);
        return this.performRequest(request);
    }

    protected RestResponse performRequest(HttpUriRequest request) throws IOException {
        try {
            HttpResponse response = this.httpClient.execute(request);
            RestResponse restResponse = RestResponse.createRestResponse(response);
            return restResponse;
        }
        catch (ClientProtocolException e1) {
            throw new IOException(e1);
        }
        catch (IOException e1) {
            throw new IOException(e1);
        }
    }

    protected HttpUriRequest setupRequest(String path, String method, Map<String, Object> params) {
        HttpUriRequest request = this.buildMethod(method, path, params);
        request.addHeader((Header)new BasicHeader("Accept", "application/json"));
        request.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
        String s = this.token + ":" + this.secret;
        String auth = new String(Base64.encodeBase64((byte[])s.getBytes()));
        request.setHeader((Header)new BasicHeader("Authorization", "Basic " + auth));
        return request;
    }

    protected HttpUriRequest buildMethod(String method, String path, Map<String, Object> params) {
        if (StringUtils.equals((CharSequence)method, (CharSequence)GET)) {
            return this.generateGetRequest(path, params);
        }
        if (StringUtils.equals((CharSequence)method, (CharSequence)POST)) {
            return this.generatePostRequest(path, params);
        }
        if (StringUtils.equals((CharSequence)method, (CharSequence)PUT)) {
            return this.generatePutRequest(path, params);
        }
        if (StringUtils.equals((CharSequence)method, (CharSequence)DELETE)) {
            return this.generateDeleteRequest(path);
        }
        throw new RuntimeException("Must not be here.");
    }

    protected HttpGet generateGetRequest(String path, Map<String, Object> paramMap) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (String key : paramMap.keySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(key, paramMap.get(key).toString()));
        }
        URI uri = this.buildUri(path, pairs);
        return new HttpGet(uri);
    }

    protected HttpPost generatePostRequest(String path, Map<String, Object> paramMap) {
        URI uri = this.buildUri(path);
        String s = JSONObject.toJSONString(paramMap);
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new StringEntity(s, ContentType.APPLICATION_JSON));
        return post;
    }

    protected HttpPut generatePutRequest(String path, Map<String, Object> paramMap) {
        URI uri = this.buildUri(path);
        HttpPut put = new HttpPut(uri);
        if (paramMap != null) {
            String s = JSONObject.toJSONString(paramMap);
            put.setEntity((HttpEntity)new StringEntity(s, ContentType.APPLICATION_JSON));
        }
        return put;
    }

    public void upload(String uri, File sourceFile, String contentType) throws IOException {
        String path = this.getPath(uri);
        HttpPut request = (HttpPut)this.setupRequest(path, PUT, null);
        request.setEntity((HttpEntity)(contentType == null ? new FileEntity(sourceFile) : new FileEntity(sourceFile, ContentType.parse((String)contentType))));
        this.performRequest((HttpUriRequest)request);
    }

    public void download(String uri, File destFile) throws IOException {
        String path = this.getPath(uri);
        HttpGet request = (HttpGet)this.setupRequest(path, GET, Collections.<String, Object>emptyMap());
        OutputStream outputStream = null;
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode >= 400) {
                throw new IOException(EntityUtils.toString((HttpEntity)entity));
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(destFile));
            entity.writeTo(outputStream);
        }
        catch (ClientProtocolException e1) {
            throw new IOException(e1);
        }
        catch (IOException e1) {
            throw new IOException(e1);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    protected HttpDelete generateDeleteRequest(String path) {
        URI uri = this.buildUri(path);
        return new HttpDelete(uri);
    }

    protected URI buildUri(String path) {
        return this.buildUri(path, null);
    }

    protected URI buildUri(String path, List<NameValuePair> queryStringParams) {
        URI uri;
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (queryStringParams != null && queryStringParams.size() > 0) {
            sb.append("?");
            sb.append(URLEncodedUtils.format(queryStringParams, (String)"UTF-8"));
        }
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid uri", e);
        }
        return uri;
    }
}

