/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class RestResponse {
    protected String responseText;
    protected boolean error;
    protected String contentType;
    protected String location;
    protected int status;
    protected String firstLink;
    protected String lastLink;
    protected String nextLink;
    protected String previousLink;

    public RestResponse() {
    }

    public RestResponse(String text, int status) {
        this.responseText = text;
        this.error = status >= 400;
        this.status = status;
    }

    public static RestResponse createRestResponse(HttpResponse httpResponse) {
        RestResponse restResponse = new RestResponse();
        try {
            restResponse.setStatus(httpResponse.getStatusLine().getStatusCode());
            HttpEntity entity = httpResponse.getEntity();
            String responseText = "";
            if (entity != null) {
                responseText = EntityUtils.toString((HttpEntity)entity);
            }
            if (responseText.length() == 0) {
                responseText = "{}";
            }
            if (responseText.contains("access-denied")) {
                restResponse.setError(true);
            } else if (restResponse.getStatus() >= 400) {
                restResponse.setError(true);
            }
            restResponse.setResponseText(responseText);
            for (Header header : httpResponse.getHeaders("Content-Type")) {
                restResponse.setContentType(header.getValue());
            }
            for (Header header : httpResponse.getHeaders("Location")) {
                restResponse.setLocation(header.getValue());
            }
            for (Header header : httpResponse.getHeaders("Link")) {
                restResponse.parseLinkHeader(header.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return restResponse;
    }

    public void parseLinkHeader(String link) {
        String[] links;
        for (String part : links = link.split(",")) {
            String linkPart;
            String[] segments = part.split(";");
            if (segments.length < 2 || !(linkPart = segments[0].trim()).startsWith("<") || !linkPart.endsWith(">")) continue;
            linkPart = linkPart.substring(1, linkPart.length() - 1);
            for (int i = 1; i < segments.length; ++i) {
                String[] rel = segments[i].trim().split("=");
                if (rel.length < 2 || !"rel".equals(rel[0])) continue;
                String relValue = rel[1];
                if (relValue.startsWith("\"") && relValue.endsWith("\"")) {
                    relValue = relValue.substring(1, relValue.length() - 1);
                }
                if ("first".equals(relValue)) {
                    this.firstLink = linkPart;
                    continue;
                }
                if ("last".equals(relValue)) {
                    this.lastLink = linkPart;
                    continue;
                }
                if ("next".equals(relValue)) {
                    this.nextLink = linkPart;
                    continue;
                }
                if (!"previous".equals(relValue)) continue;
                this.previousLink = linkPart;
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public boolean isError() {
        return this.error;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isJson() {
        return this.contentType.toLowerCase().contains("application/json");
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getFirstLink() {
        return this.firstLink;
    }

    public void setFirstLink(String firstLink) {
        this.firstLink = firstLink;
    }

    public String getLastLink() {
        return this.lastLink;
    }

    public void setLastLink(String lastLink) {
        this.lastLink = lastLink;
    }

    public String getNextLink() {
        return this.nextLink;
    }

    public void setNextLink(String nextLink) {
        this.nextLink = nextLink;
    }

    public String getPreviousLink() {
        return this.previousLink;
    }

    public void setPreviousLink(String previousLink) {
        this.previousLink = previousLink;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName()).append(this.hashCode()).append("\n");
        buf.append("status:").append(this.status).append("\n");
        buf.append("error:").append(this.error).append("\n");
        buf.append("contentType:").append(this.contentType).append("\n");
        buf.append("location:").append(this.location).append("\n");
        buf.append("responseText:").append(this.responseText).append("\n");
        buf.append("firstLink:").append(this.firstLink).append("\n");
        buf.append("lastLink:").append(this.lastLink).append("\n");
        buf.append("nextLink:").append(this.nextLink).append("\n");
        buf.append("previousLink:").append(this.previousLink).append("\n");
        return buf.toString();
    }
}

