/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthRestClient;
import com.bandwidth.sdk.model.AccountInfo;
import com.bandwidth.sdk.model.AccountTransaction;
import com.bandwidth.sdk.model.BaseModelObject;
import com.bandwidth.sdk.model.ModelBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Account
extends BaseModelObject {
    public static Account getAccount() {
        BandwidthRestClient client = BandwidthRestClient.getInstance();
        return new Account(client);
    }

    public Account(BandwidthRestClient client) {
        super(client, null);
    }

    public AccountInfo getAccountInfo() throws IOException {
        JSONObject jsonObject = this.client.getObject(this.getUri());
        return new AccountInfo(this.client, jsonObject);
    }

    public TransactionsQueryBuilder queryTransactionsBuilder() {
        return new TransactionsQueryBuilder();
    }

    private List<AccountTransaction> getTransactions(Map<String, Object> params) throws IOException {
        String transactionsUri = this.getAccountTransactionsUri();
        JSONArray array = this.client.getArray(transactionsUri, params);
        ArrayList<AccountTransaction> transactions = new ArrayList<AccountTransaction>();
        for (Object obj : array) {
            transactions.add(new AccountTransaction(this.client, (JSONObject)obj));
        }
        return transactions;
    }

    private String getAccountTransactionsUri() {
        return StringUtils.join((Object[])new String[]{this.getUri(), "transactions"}, (char)'/');
    }

    @Override
    protected String getUri() {
        return this.client.getUserResourceUri("account");
    }

    public class TransactionsQueryBuilder {
        private Map<String, Object> params = new HashMap<String, Object>();

        public TransactionsQueryBuilder maxItems(int maxItems) {
            this.params.put("maxItems", maxItems);
            return this;
        }

        public TransactionsQueryBuilder fromDate(Date fromDate) {
            this.params.put("fromDate", ModelBase.dateFormat.format(fromDate));
            return this;
        }

        public TransactionsQueryBuilder toDate(Date toDate) {
            this.params.put("toDate", ModelBase.dateFormat.format(toDate));
            return this;
        }

        public TransactionsQueryBuilder type(String type) {
            this.params.put("type", type);
            return this;
        }

        public TransactionsQueryBuilder page(int page) {
            this.params.put("page", page);
            return this;
        }

        public TransactionsQueryBuilder size(int size) {
            this.params.put("size", size);
            return this;
        }

        public List<AccountTransaction> list() throws IOException {
            return Account.this.getTransactions(this.params);
        }
    }
}

