/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.ResourceList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class Application
extends ResourceBase {
    public static Application get(String id) throws Exception {
        assert (id != null);
        BandwidthClient client = BandwidthClient.getInstance();
        return Application.get(client, id);
    }

    public static Application get(BandwidthClient client, String id) throws Exception {
        assert (id != null);
        String applicationUri = client.getUserResourceInstanceUri("applications", id);
        JSONObject applicationObj = Application.toJSONObject(client.get(applicationUri, null));
        Application application = new Application(client, applicationObj);
        return application;
    }

    public static ResourceList<Application> list() throws IOException {
        return Application.list(0, 25);
    }

    public static ResourceList<Application> list(int page, int size) throws IOException {
        BandwidthClient client = BandwidthClient.getInstance();
        return Application.list(client, page, size);
    }

    public static ResourceList<Application> list(BandwidthClient client, int page, int size) throws IOException {
        String applicationUri = client.getUserResourceUri("applications");
        ResourceList<Application> applications = new ResourceList<Application>(page, size, applicationUri, Application.class);
        applications.setClient(client);
        applications.initialize();
        return applications;
    }

    public static Application create(String name) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        return Application.create(params);
    }

    public static Application create(Map<String, Object> params) throws Exception {
        return Application.create(BandwidthClient.getInstance(), params);
    }

    public static Application create(BandwidthClient client, Map<String, Object> params) throws Exception {
        assert (client != null);
        RestResponse response = client.post("applications", params);
        return new Application(client, Application.toJSONObject(response));
    }

    public Application(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    protected String getUri() {
        return this.client.getUserResourceInstanceUri("applications", this.getId());
    }

    public String getName() {
        return this.getPropertyAsString("name");
    }

    public String getIncomingCallUrl() {
        return this.getPropertyAsString("incomingCallUrl");
    }

    public String getIncomingSmsUrl() {
        return this.getPropertyAsString("incomingSmsUrl");
    }

    public String getCallbackHttpMethod() {
        return this.getPropertyAsString("callbackHttpMethod");
    }

    public String getIncomingCallFallbackUrl() {
        return this.getPropertyAsString("incomingCallFallbackUrl");
    }

    public Long getIncomingCallUrlCallbackTimeout() {
        return this.getPropertyAsLong("incomingCallUrlCallbackTimeout");
    }

    public Long getIncomingSmsUrlCallbackTimeout() {
        return this.getPropertyAsLong("incomingSmsUrlCallbackTimeout");
    }

    public boolean isAutoAnswer() {
        return this.getPropertyAsBoolean("autoAnswer");
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.putProperty("name", name);
    }

    public void setIncomingCallUrl(String incomingCallUrl) {
        this.putProperty("incomingCallUrl", incomingCallUrl);
    }

    public void setIncomingSmsUrl(String incomingSmsUrl) {
        this.putProperty("incomingSmsUrl", incomingSmsUrl);
    }

    public void setAutoAnswer(boolean autoAnswer) {
        this.putProperty("autoAnswer", autoAnswer);
    }

    public void setIncomingCallFallbackUrl(String incomingCallFallbackUrl) {
        this.putProperty("incomingCallFallbackUrl", incomingCallFallbackUrl);
    }

    public void setIncomingCallUrlCallbackTimeout(Long incomingCallUrlCallbackTimeout) {
        this.putProperty("incomingCallUrlCallbackTimeout", incomingCallUrlCallbackTimeout);
    }

    public void setIncomingSmsUrlCallbackTimeout(Long incomingSmsUrlCallbackTimeout) {
        this.putProperty("incomingSmsUrlCallbackTimeout", incomingSmsUrlCallbackTimeout);
    }

    public void setCallbackHttpMethod(String callbackHttpMethod) {
        this.putProperty("callbackHttpMethod", callbackHttpMethod);
    }

    public void commit() throws IOException {
        Map<String, Object> params = this.toMap();
        params.remove("id");
        this.client.post(this.getUri(), params);
    }

    public void delete() throws IOException {
        this.client.delete(this.getUri());
    }

    public String toString() {
        return "Application{id='" + this.getId() + '\'' + ", name='" + this.getName() + '\'' + ", incomingCallUrl='" + this.getIncomingCallUrl() + '\'' + ", incomingSmsUrl='" + this.getIncomingSmsUrl() + '\'' + ", autoAnswer=" + this.isAutoAnswer() + ", incomingCallUrlCallbackTimeout='" + this.getIncomingCallUrlCallbackTimeout() + '\'' + ", incomingSmsUrlCallbackTimeout='" + this.getIncomingSmsUrlCallbackTimeout() + '\'' + ", callbackHttpMethod='" + this.getCallbackHttpMethod() + '\'' + ", incomingCallFallbackUrl='" + this.getIncomingCallFallbackUrl() + '\'' + '}';
    }
}

