/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.AppPlatformException;
import com.bandwidth.sdk.model.AbsModelObject;
import com.bandwidth.sdk.model.AnswerEvent;
import com.bandwidth.sdk.model.DtmfEvent;
import com.bandwidth.sdk.model.Event;
import com.bandwidth.sdk.model.EventType;
import com.bandwidth.sdk.model.GatherEvent;
import com.bandwidth.sdk.model.HangupEvent;
import com.bandwidth.sdk.model.IncomingCallEvent;
import com.bandwidth.sdk.model.PlaybackEvent;
import com.bandwidth.sdk.model.RecordingEvent;
import com.bandwidth.sdk.model.RejectEvent;
import com.bandwidth.sdk.model.SmsEvent;
import com.bandwidth.sdk.model.SpeakEvent;
import com.bandwidth.sdk.model.TimeoutEvent;
import com.bandwidth.sdk.model.Visitor;
import java.util.Date;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BaseEvent
extends AbsModelObject
implements Event {
    protected EventType eventType;

    public static Event createEventFromString(String in) throws AppPlatformException {
        JSONObject jsonObj = null;
        try {
            jsonObj = (JSONObject)new JSONParser().parse(in);
        }
        catch (ParseException e) {
            throw new AppPlatformException(e);
        }
        EventType eventType = EventType.getEnum((String)jsonObj.get((Object)"eventType"));
        Event event = null;
        switch (eventType) {
            case INCOMINGCALL: {
                event = new IncomingCallEvent(jsonObj);
                break;
            }
            case ANSWER: {
                event = new AnswerEvent(jsonObj);
                break;
            }
            case SPEAK: {
                event = new SpeakEvent(jsonObj);
                break;
            }
            case PLAYBACK: {
                event = new PlaybackEvent(jsonObj);
                break;
            }
            case GATHER: {
                event = new GatherEvent(jsonObj);
                break;
            }
            case HANGUP: {
                event = new HangupEvent(jsonObj);
                break;
            }
            case DTMF: {
                event = new DtmfEvent(jsonObj);
                break;
            }
            case REJECT: {
                event = new RejectEvent(jsonObj);
                break;
            }
            case RECORDING: {
                event = new RecordingEvent(jsonObj);
                break;
            }
            case SMS: {
                event = new SmsEvent(jsonObj);
                break;
            }
            case TIMEOUT: {
                event = new TimeoutEvent(jsonObj);
                break;
            }
            default: {
                event = new BaseEvent(jsonObj);
            }
        }
        return event;
    }

    @Override
    public void execute(Visitor visitor) {
        visitor.processEvent(this);
    }

    protected BaseEvent(JSONObject json) {
        this.updateProperties(json);
        this.eventType = EventType.getEnum((String)json.get((Object)"eventType"));
    }

    public Date getTime() {
        Long time = this.getPropertyAsLong("time");
        return new Date(time);
    }

    public Object getData() {
        return this.getProperty("data");
    }

    @Override
    public String getProperty(String property) {
        return this.getPropertyAsString(property);
    }

    @Override
    public void setProperty(String name, String value) {
        this.putProperty(name, value);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    public String toString() {
        return "Event{id='" + this.getId() + '\'' + ", time=" + this.getTime() + ", data=" + this.getData() + '}';
    }
}

