/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk;

import com.bandwidth.sdk.Client;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.NumberInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BandwidthRestClient
implements Client {
    protected static final String GET = "get";
    protected static final String POST = "post";
    protected static final String PUT = "put";
    protected static final String DELETE = "delete";
    public static String BANDWIDTH_USER_ID = "BANDWIDTH_USER_ID";
    public static String BANDWIDTH_API_TOKEN = "BANDWIDTH_API_TOKEN";
    public static String BANDWIDTH_API_SECRET = "BANDWIDTH_API_SECRET";
    public static String BANDWIDTH_API_ENDPOINT = "BANDWIDTH_API_ENDPOINT";
    public static String BANDWIDTH_API_VERSION = "BANDWIDTH_API_VERSION";
    protected final String usersUri;
    protected final String baseUri;
    protected final String token;
    protected final String secret;
    protected HttpClient httpClient;
    protected static BandwidthRestClient INSTANCE;
    protected String apiEndpoint;
    protected String apiVersion;

    public static BandwidthRestClient getInstance() {
        if (INSTANCE == null) {
            Map<String, String> env = System.getenv();
            for (String envName : env.keySet()) {
            }
            String userId = env.get(BANDWIDTH_USER_ID);
            String apiToken = env.get(BANDWIDTH_API_TOKEN);
            String apiSecret = env.get(BANDWIDTH_API_SECRET);
            String apiEndpoint = env.get(BANDWIDTH_API_ENDPOINT);
            String apiVersion = env.get(BANDWIDTH_API_VERSION);
            INSTANCE = new BandwidthRestClient(userId, apiToken, apiSecret, apiEndpoint, apiVersion);
        }
        return INSTANCE;
    }

    public String getUserResourceUri(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        return StringUtils.join((Object[])new String[]{this.getUserUri(), path}, (String)"/");
    }

    public String getUserResourceInstanceUri(String path, String instanceId) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)instanceId)) {
            throw new IllegalArgumentException("Path and Instance Id cannot be null");
        }
        return this.getUserResourceUri(path) + "/" + instanceId;
    }

    public String getBaseResourceUri(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        return path + "/";
    }

    protected BandwidthRestClient(String userId, String token, String secret, String apiEndpoint, String apiVersion) {
        this.usersUri = String.format("users/%s", userId);
        this.baseUri = "";
        this.token = token;
        this.secret = secret;
        this.apiEndpoint = apiEndpoint;
        this.apiVersion = apiVersion;
        if (apiEndpoint == null || apiVersion == null) {
            this.apiEndpoint = "https://api.catapult.inetwork.com";
            this.apiVersion = "v1";
        }
        this.httpClient = new DefaultHttpClient();
    }

    public String getUserUri() {
        return this.usersUri;
    }

    public NumberInfo getNumberInfoByNumber(String number) throws IOException {
        String uri = StringUtils.join((Object[])new String[]{"phoneNumbers", "numberInfo", number}, (char)'/');
        JSONObject object = this.getObject(uri);
        return new NumberInfo(object);
    }

    @Override
    public RestResponse get(String uri, Map<String, Object> params) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        String path = this.getPath(uri);
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (String key : params.keySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(key, params.get(key).toString()));
        }
        URI fullUri = this.buildUri(path, pairs);
        HttpGet httpGet = new HttpGet(fullUri);
        this.setHeaders((HttpRequest)httpGet);
        HttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
        return RestResponse.createRestResponse(httpResponse);
    }

    protected void setHeaders(HttpRequest request) {
        request.addHeader((Header)new BasicHeader("Accept", "application/json"));
        request.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
        String s = this.token + ":" + this.secret;
        String auth = new String(Base64.encodeBase64((byte[])s.getBytes()));
        request.setHeader((Header)new BasicHeader("Authorization", "Basic " + auth));
    }

    public JSONArray getArray(String uri, Map<String, Object> params) throws IOException {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, GET, params);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
        if (response.isJson()) {
            try {
                return (JSONArray)new JSONParser().parse(response.getResponseText());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        throw new IOException("Response is not a JSON format.");
    }

    public JSONObject getObject(String uri) throws IOException {
        String path = this.getPath(uri);
        return this.getObjectFromLocation(path);
    }

    public JSONObject getObjectFromLocation(String locationUrl) throws IOException {
        RestResponse response = this.request(locationUrl, GET);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
        if (response.isJson()) {
            try {
                return (JSONObject)new JSONParser().parse(response.getResponseText());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        throw new IOException("Response is not a JSON format.");
    }

    public JSONObject create(String uri, Map<String, Object> params) throws IOException {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, POST, params);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
        String location = response.getLocation();
        if (location != null) {
            response = this.request(location, GET);
            if (response.isError()) {
                throw new IOException(response.getResponseText());
            }
            if (response.isJson()) {
                try {
                    return (JSONObject)new JSONParser().parse(response.getResponseText());
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
            }
            throw new IOException("Response is not a JSON format.");
        }
        throw new IOException("There is no location of new application.");
    }

    public RestResponse post(String uri, Map<String, Object> params) throws IOException {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, POST, params);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
        return response;
    }

    public void delete(String uri) throws IOException {
        String path = this.getPath(uri);
        RestResponse response = this.request(path, DELETE);
        if (response.isError()) {
            throw new IOException(response.getResponseText());
        }
    }

    public void uploadFile(String uri, File sourceFile, String contentType) throws IOException {
        String path = this.getPath(uri);
        HttpPut request = (HttpPut)this.setupRequest(path, PUT, null);
        request.setEntity((HttpEntity)(contentType == null ? new FileEntity(sourceFile) : new FileEntity(sourceFile, ContentType.parse((String)contentType))));
        this.performRequest((HttpUriRequest)request);
    }

    public void downloadFileTo(String uri, File destFile) throws IOException {
        String path = this.getPath(uri);
        HttpGet request = (HttpGet)this.setupRequest(path, GET, Collections.<String, Object>emptyMap());
        OutputStream outputStream = null;
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode >= 400) {
                throw new IOException(EntityUtils.toString((HttpEntity)entity));
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(destFile));
            entity.writeTo(outputStream);
        }
        catch (ClientProtocolException e1) {
            throw new IOException(e1);
        }
        catch (IOException e1) {
            throw new IOException(e1);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    public String getPath(String uri) {
        Object[] parts = new String[]{this.apiEndpoint, this.apiVersion, null};
        String base = StringUtils.join((Object[])parts, (String)"/");
        if (!uri.contains(base)) {
            parts[2] = uri;
            return StringUtils.join((Object[])parts, (String)"/");
        }
        return uri;
    }

    protected RestResponse request(String path, String method) throws IOException {
        return this.request(path, method, null);
    }

    protected RestResponse request(String path, String method, Map<String, Object> paramList) throws IOException {
        if (paramList == null) {
            paramList = Collections.emptyMap();
        }
        HttpUriRequest request = this.setupRequest(path, method, paramList);
        return this.performRequest(request);
    }

    protected RestResponse performRequest(HttpUriRequest request) throws IOException {
        try {
            HttpResponse response = this.httpClient.execute(request);
            HttpEntity entity = response.getEntity();
            String responseBody = "";
            if (entity != null) {
                responseBody = EntityUtils.toString((HttpEntity)entity);
            }
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            RestResponse restResponse = new RestResponse(responseBody, statusCode);
            Header[] headers = response.getHeaders("Content-Type");
            if (headers.length > 0) {
                restResponse.setContentType(headers[0].getValue());
            }
            if ((headers = response.getHeaders("Location")).length > 0) {
                restResponse.setLocation(headers[0].getValue());
            }
            return restResponse;
        }
        catch (ClientProtocolException e1) {
            throw new IOException(e1);
        }
        catch (IOException e1) {
            throw new IOException(e1);
        }
    }

    protected HttpUriRequest setupRequest(String path, String method, Map<String, Object> params) {
        HttpUriRequest request = this.buildMethod(method, path, params);
        request.addHeader((Header)new BasicHeader("Accept", "application/json"));
        request.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
        String s = this.token + ":" + this.secret;
        String auth = new String(Base64.encodeBase64((byte[])s.getBytes()));
        request.setHeader((Header)new BasicHeader("Authorization", "Basic " + auth));
        return request;
    }

    protected HttpUriRequest buildMethod(String method, String path, Map<String, Object> params) {
        if (StringUtils.equals((CharSequence)method, (CharSequence)GET)) {
            return this.generateGetRequest(path, params);
        }
        if (StringUtils.equals((CharSequence)method, (CharSequence)POST)) {
            return this.generatePostRequest(path, params);
        }
        if (StringUtils.equals((CharSequence)method, (CharSequence)PUT)) {
            return this.generatePutRequest(path, params);
        }
        if (StringUtils.equals((CharSequence)method, (CharSequence)DELETE)) {
            return this.generateDeleteRequest(path);
        }
        throw new RuntimeException("Must not be here.");
    }

    protected HttpGet generateGetRequest(String path, Map<String, Object> paramMap) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (String key : paramMap.keySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(key, paramMap.get(key).toString()));
        }
        URI uri = this.buildUri(path, pairs);
        return new HttpGet(uri);
    }

    protected HttpPost generatePostRequest(String path, Map<String, Object> paramMap) {
        URI uri = this.buildUri(path);
        String s = JSONObject.toJSONString(paramMap);
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new StringEntity(s, ContentType.APPLICATION_JSON));
        return post;
    }

    protected HttpPut generatePutRequest(String path, Map<String, Object> paramMap) {
        URI uri = this.buildUri(path);
        HttpPut put = new HttpPut(uri);
        if (paramMap != null) {
            String s = JSONObject.toJSONString(paramMap);
            put.setEntity((HttpEntity)new StringEntity(s, ContentType.APPLICATION_JSON));
        }
        return put;
    }

    protected HttpDelete generateDeleteRequest(String path) {
        URI uri = this.buildUri(path);
        return new HttpDelete(uri);
    }

    protected URI buildUri(String path) {
        return this.buildUri(path, null);
    }

    protected URI buildUri(String path, List<NameValuePair> queryStringParams) {
        URI uri;
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (queryStringParams != null && queryStringParams.size() > 0) {
            sb.append("?");
            sb.append(URLEncodedUtils.format(queryStringParams, (String)"UTF-8"));
        }
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid uri", e);
        }
        return uri;
    }
}

