/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthRestClient;
import com.bandwidth.sdk.model.BaseModelObject;
import com.bandwidth.sdk.model.ConferenceMember;
import com.bandwidth.sdk.model.Gender;
import com.bandwidth.sdk.model.SentenceLocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Conference
extends BaseModelObject {
    public static Conference getConference(String id) throws IOException {
        return Conference.getConference(BandwidthRestClient.getInstance(), id);
    }

    public static Conference getConference(BandwidthRestClient client, String id) throws IOException {
        String conferencesUri = client.getUserResourceUri("conferences");
        String conferenceUri = StringUtils.join((Object[])new String[]{conferencesUri, id}, (char)'/');
        JSONObject jsonObject = client.getObject(conferenceUri);
        return new Conference(client, jsonObject);
    }

    public static Conference createConference(Map<String, Object> params) throws IOException {
        return Conference.createConference(BandwidthRestClient.getInstance(), params);
    }

    public static Conference createConference(BandwidthRestClient client, Map<String, Object> params) throws IOException {
        String conferencesUri = client.getUserResourceUri("conferences");
        JSONObject jsonObject = client.create(conferencesUri, params);
        return new Conference(client, jsonObject);
    }

    public Conference(BandwidthRestClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected String getUri() {
        return this.client.getUserResourceInstanceUri("conferences", this.getId());
    }

    public String getFrom() {
        return this.getPropertyAsString("from");
    }

    public String getCallbackUrl() {
        return this.getPropertyAsString("callbackUrl");
    }

    public String getFallbackUrl() {
        return this.getPropertyAsString("fallbackUrl");
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public Long getActiveMembers() {
        return this.getPropertyAsLong("activeMembers");
    }

    public Long getCallbackTimeout() {
        return this.getPropertyAsLong("callbackTimeout");
    }

    public Date getCompletedTime() {
        return this.getPropertyAsDate("completedTime");
    }

    public Date getCreatedTime() {
        return this.getPropertyAsDate("createdTime");
    }

    public void complete() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", "completed");
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public void mute() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mute", String.valueOf(true));
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject jsonObject = this.client.getObject(uri);
        this.updateProperties(jsonObject);
    }

    public List<ConferenceMember> getMembers() throws IOException {
        String membersPath = StringUtils.join((Object[])new String[]{this.getUri(), "members"}, (char)'/');
        JSONArray array = this.client.getArray(membersPath, null);
        ArrayList<ConferenceMember> members = new ArrayList<ConferenceMember>();
        for (Object obj : array) {
            members.add(new ConferenceMember(this.client, (JSONObject)obj));
        }
        return members;
    }

    public ConferenceAudioBuilder conferenceAudioBuilder() {
        return new ConferenceAudioBuilder();
    }

    private void createConferenceAudio(Map<String, Object> params) throws IOException {
        String audioPath = StringUtils.join((Object[])new String[]{this.getUri(), "audio"}, (char)'/');
        this.client.post(audioPath, params);
    }

    public String toString() {
        return "Conference{id='" + this.getId() + '\'' + ", from='" + this.getFrom() + '\'' + ", callbackUrl='" + this.getCallbackUrl() + '\'' + ", fallbackUrl='" + this.getFallbackUrl() + '\'' + ", state=" + this.getState() + ", activeMembers=" + this.getActiveMembers() + ", callbackTimeout=" + this.getCallbackTimeout() + ", completedTime=" + this.getCompletedTime() + ", createdTime=" + this.getCreatedTime() + '}';
    }

    public class ConferenceAudioBuilder {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public ConferenceAudioBuilder fileUrl(String fileUrl) {
            this.params.put("fileUrl", fileUrl);
            return this;
        }

        public ConferenceAudioBuilder sentence(String sentence) {
            this.params.put("sentence", sentence);
            return this;
        }

        public ConferenceAudioBuilder gender(Gender gender) {
            this.params.put("gender", gender.name());
            return this;
        }

        public ConferenceAudioBuilder locale(SentenceLocale locale) {
            this.params.put("locale", locale.restValue);
            return this;
        }

        public ConferenceAudioBuilder voice(String voice) {
            this.params.put("voice", voice);
            return this;
        }

        public void create() throws IOException {
            Conference.this.createConferenceAudio(this.params);
        }
    }
}

