/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.model.MediaFile;
import com.bandwidth.sdk.model.MediaMimeType;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.ResourceList;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;

public class Media
extends ResourceBase {
    public static MediaFile get(String id) throws Exception {
        return Media.get(BandwidthClient.getInstance(), id);
    }

    public static MediaFile get(BandwidthClient client, String id) throws Exception {
        String mediaUri = client.getUserResourceInstanceUri("media", id);
        JSONObject jsonObject = Media.toJSONObject(client.get(mediaUri, null));
        return new MediaFile(client, jsonObject);
    }

    public static ResourceList<MediaFile> list() throws IOException {
        return Media.list(0, 25);
    }

    public static ResourceList<MediaFile> list(int page, int size) throws IOException {
        return Media.list(BandwidthClient.getInstance(), page, size);
    }

    public static ResourceList<MediaFile> list(BandwidthClient client, int page, int size) throws IOException {
        String mediaUri = client.getUserResourceUri("media");
        ResourceList<MediaFile> mediaFiles = new ResourceList<MediaFile>(page, size, mediaUri, MediaFile.class);
        mediaFiles.setClient(client);
        mediaFiles.initialize();
        return mediaFiles;
    }

    public static Media create() {
        return new Media(BandwidthClient.getInstance());
    }

    public Media(BandwidthClient client) {
        super(client, null);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        if (jsonObject != null) {
            this.id = (String)jsonObject.get((Object)"id");
            this.updateProperties(jsonObject);
        }
    }

    public MediaFile upload(String mediaName, File file, MediaMimeType contentType) throws IOException {
        String uri = StringUtils.join((Object[])new String[]{this.getUri(), mediaName}, (char)'/');
        this.client.upload(uri, file, contentType.toString());
        ResourceList<MediaFile> mediaFiles = Media.list(this.client, 0, 25);
        for (MediaFile mediaFile : mediaFiles) {
            if (!StringUtils.equals((CharSequence)mediaFile.getMediaName(), (CharSequence)mediaName)) continue;
            return mediaFile;
        }
        return null;
    }

    public void download(String mediaName, File file) throws IOException {
        String uri = this.client.getUserResourceInstanceUri("media", mediaName);
        this.client.download(uri, file);
    }

    protected String getUri() {
        return this.client.getUserResourceUri("media");
    }
}

