/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.model.ResourceBase;
import java.io.File;
import java.io.IOException;
import org.json.simple.JSONObject;

public class MediaFile
extends ResourceBase {
    public MediaFile(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    public Long getContentLength() {
        return this.getPropertyAsLong("contentLength");
    }

    public String getMediaName() {
        return this.getPropertyAsString("mediaName");
    }

    public String getContent() {
        return this.getPropertyAsString("content");
    }

    public void downloadTo(File destFile) throws IOException {
        this.client.download(this.getUri(), destFile);
    }

    public void delete() throws IOException {
        this.client.delete(this.getUri());
    }

    public String toString() {
        return "MediaFile{mediaName='" + this.getMediaName() + '\'' + ", contentLength='" + this.getContentLength() + '\'' + ", content='" + this.getContent() + '\'' + '}';
    }

    protected String getUri() {
        return this.client.getUserResourceInstanceUri("media", this.getMediaName());
    }
}

