/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.ResourceList;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;

public class Recording
extends ResourceBase {
    String parentUri;

    public static ResourceList<Recording> list() throws IOException {
        return Recording.list(0, 25);
    }

    public static ResourceList<Recording> list(int page, int size) throws IOException {
        return Recording.list(BandwidthClient.getInstance(), page, size);
    }

    public static ResourceList<Recording> list(BandwidthClient client, int page, int size) throws IOException {
        String recordingUri = client.getUserResourceUri("recordings");
        ResourceList<Recording> recordings = new ResourceList<Recording>(page, size, recordingUri, Recording.class);
        recordings.setClient(client);
        recordings.initialize();
        return recordings;
    }

    public static Recording get(String id) throws Exception {
        return Recording.get(BandwidthClient.getInstance(), id);
    }

    public static Recording get(BandwidthClient client, String id) throws Exception {
        String recordingsUri = client.getUserResourceUri("recordings");
        String uri = StringUtils.join((Object[])new String[]{recordingsUri, id}, (char)'/');
        JSONObject jsonObject = Recording.toJSONObject(client.get(uri, null));
        return new Recording(client, recordingsUri, jsonObject);
    }

    public Recording(BandwidthClient client, String parentUri, JSONObject jsonObject) {
        super(client, jsonObject);
        this.parentUri = parentUri;
    }

    public Recording(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    protected String getUri() {
        return null;
    }

    public String getMedia() {
        return this.getPropertyAsString("media");
    }

    public String getCall() {
        return this.getPropertyAsString("call");
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public Date getStartTime() {
        return this.getPropertyAsDate("startTime");
    }

    public Date getEndTime() {
        return this.getPropertyAsDate("endTime");
    }

    public String toString() {
        return "Recording{id='" + this.getId() + '\'' + ", media='" + this.getMedia() + '\'' + ", call='" + this.getCall() + '\'' + ", state='" + this.getState() + '\'' + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + '}';
    }
}

