/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.Client;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ResourceList<E>
extends ArrayList<E> {
    protected int page;
    protected int size;
    protected int index = 0;
    protected String previousLink;
    protected String nextLink = null;
    protected String firstLink;
    RestResponse response;
    protected Class<E> clazz;
    protected String resourceUri;
    Client client;

    public ResourceList(String resourceUri, Class<E> clazz) {
        this.page = 0;
        this.size = 25;
        this.resourceUri = resourceUri;
        this.clazz = clazz;
    }

    public ResourceList(int page, int size, String resourceUri, Class<E> clazz) {
        this.page = page;
        this.size = size;
        this.resourceUri = resourceUri;
        this.clazz = clazz;
    }

    public void initialize() {
        JSONObject params = new JSONObject();
        params.put((Object)"page", (Object)this.page);
        params.put((Object)"size", (Object)this.size);
        this.getPage(params);
    }

    @Override
    public Iterator<E> iterator() {
        Iterator it = new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return ResourceList.this.index < ResourceList.this.size();
            }

            @Override
            public E next() {
                Object elem = ResourceList.this.get(ResourceList.this.index++);
                if (ResourceList.this.index >= ResourceList.this.size() && ResourceList.this.nextLink != null) {
                    ResourceList.this.getNextPage();
                }
                return elem;
            }

            @Override
            public void remove() {
            }
        };
        return it;
    }

    protected void getNextPage() {
        JSONObject params = new JSONObject();
        ++this.page;
        params.put((Object)"page", (Object)this.page);
        params.put((Object)"size", (Object)this.size);
        this.clear();
        this.getPage(params);
    }

    protected void getPage(JSONObject params) {
        if (this.client == null) {
            this.client = BandwidthClient.getInstance();
        }
        try {
            RestResponse response = this.client.get(this.resourceUri, (Map<String, Object>)params);
            JSONArray array = Utils.response2JSONArray(response);
            for (Object obj : array) {
                E elem = this.clazz.getConstructor(BandwidthClient.class, JSONObject.class).newInstance(this.client, (JSONObject)obj);
                this.add(elem);
            }
            if (array.size() > 0) {
                this.index = 0;
            }
            this.setNextLink(response.getNextLink());
            this.setFirstLink(response.getFirstLink());
            this.setPreviousLink(response.getPreviousLink());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        return super.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return super.listIterator(index);
    }

    public String getPreviousLink() {
        return this.previousLink;
    }

    public void setPreviousLink(String previousLink) {
        this.previousLink = previousLink;
    }

    public String getNextLink() {
        return this.nextLink;
    }

    public void setNextLink(String nextLink) {
        this.nextLink = nextLink;
    }

    public String getFirstLink() {
        return this.firstLink;
    }

    public void setFirstLink(String firstLink) {
        this.firstLink = firstLink;
    }

    public RestResponse getResponse() {
        return this.response;
    }

    public void setResponse(RestResponse response) {
        this.response = response;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

