/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.examples;

import com.bandwidth.sdk.model.Domain;
import com.bandwidth.sdk.model.Endpoint;
import com.bandwidth.sdk.model.ResourceList;
import org.apache.commons.lang3.RandomStringUtils;

public class EndpointExample {
    public static void main(String[] args) throws Exception {
        String domainName = RandomStringUtils.randomAlphabetic((int)12);
        String domainDescription = "Domain Description";
        String endpointName = RandomStringUtils.randomAlphabetic((int)12);
        System.out.println("Creating new domain");
        Domain createdDomain = Domain.create(domainName, "Domain Description");
        System.out.println("Created domain id " + createdDomain.getId());
        System.out.println(createdDomain.toString());
        System.out.println("Creating new endpoint");
        Endpoint createdEndpoint = Endpoint.create(createdDomain.getId(), endpointName, "123456", true);
        System.out.println("Created endpoint id " + createdEndpoint.getId());
        Endpoint endpointGet = Endpoint.get(createdDomain.getId(), createdEndpoint.getId());
        System.out.println("Getting the endpoint id " + endpointGet.getId());
        System.out.println("endpointGet: " + endpointGet.toString());
        Endpoint endpointUpdate = Endpoint.update(createdDomain.getId(), endpointGet.getId(), "123456", false);
        System.out.println("Updating endpoint id " + endpointUpdate.getId());
        System.out.println("endpointUpdate: " + endpointUpdate.toString());
        ResourceList<Endpoint> domainList = Endpoint.list(createdDomain.getId());
        System.out.println("Listing Endpoints.");
        for (Endpoint currentEndpoint : domainList) {
            System.out.println(currentEndpoint.toString());
        }
        System.out.println("Deleting endpoint id " + createdDomain.getId());
        Endpoint.delete(createdDomain.getId(), createdEndpoint.getId());
        System.out.println("Deleting domain id " + createdDomain.getId());
        Domain.delete(createdDomain.getId());
    }
}

