/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.AppPlatformException;
import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.ResourceList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Domain
extends ResourceBase {
    public Domain(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    public static JSONObject toJSONObject(RestResponse response) throws ParseException {
        return (JSONObject)new JSONParser().parse(response.getResponseText());
    }

    public static Domain create(String name) throws AppPlatformException, ParseException, Exception {
        return Domain.create(name, null);
    }

    public static Domain create(String name, String description) throws AppPlatformException, ParseException, Exception {
        return Domain.create(BandwidthClient.getInstance(), name, description);
    }

    public static Domain create(BandwidthClient client, String name, String description) throws AppPlatformException, ParseException, Exception {
        assert (name != null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        if (!StringUtils.isBlank((CharSequence)description)) {
            params.put("description", description);
        }
        return Domain.create(client, params);
    }

    public static Domain create(BandwidthClient client, Map<String, Object> params) throws AppPlatformException, ParseException, Exception {
        assert (client != null && params != null);
        String domainsUri = client.getUserResourceUri("domains");
        RestResponse response = client.post(domainsUri, params);
        if (response.getStatus() > 400) {
            throw new AppPlatformException(response.getResponseText());
        }
        JSONObject callObj = Domain.toJSONObject(client.get(response.getLocation(), null));
        return new Domain(client, callObj);
    }

    public static Domain get(String id) throws ParseException, Exception {
        BandwidthClient client = BandwidthClient.getInstance();
        return Domain.get(client, id);
    }

    public static Domain get(BandwidthClient client, String id) throws ParseException, Exception {
        assert (client != null);
        String domainsUri = client.getUserResourceInstanceUri("domains", id);
        JSONObject jsonObject = Domain.toJSONObject(client.get(domainsUri, null));
        return new Domain(client, jsonObject);
    }

    public static ResourceList<Domain> list() {
        BandwidthClient client = BandwidthClient.getInstance();
        return Domain.list(client, 0, 20);
    }

    public static ResourceList<Domain> list(BandwidthClient client, int page, int size) {
        String resourceUri = client.getUserResourceUri("domains");
        ResourceList<Domain> domains = new ResourceList<Domain>(resourceUri, Domain.class);
        domains.setClient(client);
        domains.initialize();
        return domains;
    }

    public static Domain update(String id) throws AppPlatformException, ParseException, IOException, Exception {
        return Domain.update(id, null);
    }

    public static Domain update(String id, String description) throws AppPlatformException, ParseException, IOException, Exception {
        BandwidthClient client = BandwidthClient.getInstance();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (description != null) {
            params.put("description", description);
        }
        return Domain.update(client, id, params);
    }

    public static Domain update(BandwidthClient client, String id, Map<String, Object> params) throws AppPlatformException, ParseException, IOException, Exception {
        assert (client != null && id != null);
        String domainsUri = client.getUserResourceInstanceUri("domains", id);
        RestResponse response = client.post(domainsUri, params);
        if (response.getStatus() > 400) {
            throw new AppPlatformException(response.getResponseText());
        }
        JSONObject jsonObject = Domain.toJSONObject(client.get(domainsUri, null));
        return new Domain(client, jsonObject);
    }

    public static void delete(String id) throws AppPlatformException, IOException {
        assert (id != null);
        BandwidthClient client = BandwidthClient.getInstance();
        RestResponse response = client.delete(client.getUserResourceInstanceUri("domains", id));
        if (response.getStatus() > 400) {
            throw new AppPlatformException(response.getResponseText());
        }
    }

    public static void delete(BandwidthClient client, String id) throws AppPlatformException, IOException {
        assert (id != null);
        RestResponse response = client.delete(client.getUserResourceInstanceUri("domains", id));
        if (response.getStatus() > 400) {
            throw new AppPlatformException(response.getResponseText());
        }
    }

    public String getName() {
        return this.getPropertyAsString("name");
    }

    public String getDescription() {
        return this.getPropertyAsString("description");
    }

    public String getEndpointsUrl() {
        return this.getPropertyAsString("endpointsUrl");
    }

    public String toString() {
        return "Domain{id='" + this.getId() + '\'' + ", name=" + this.getName() + ", description='" + this.getDescription() + '\'' + '}';
    }
}

