/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.AppPlatformException;
import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.Credentials;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.ResourceList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Endpoint
extends ResourceBase {
    public Endpoint(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    public static JSONObject toJSONObject(RestResponse response) throws ParseException {
        return (JSONObject)new JSONParser().parse(response.getResponseText());
    }

    public static Endpoint create(BandwidthClient client, String domainId, String name, String password) throws AppPlatformException, ParseException, Exception {
        return Endpoint.create(client, domainId, name, password, null);
    }

    public static Endpoint create(BandwidthClient client, String domainId, String name, String password, String description) throws AppPlatformException, ParseException, Exception {
        return Endpoint.create(client, domainId, name, password, description, true);
    }

    public static Endpoint create(BandwidthClient client, String domainId, String name, String password, String description, boolean enabled) throws AppPlatformException, ParseException, Exception {
        return Endpoint.create(client, domainId, name, password, description, enabled, null);
    }

    public static Endpoint create(String domainId, String name, String password) throws AppPlatformException, ParseException, Exception {
        return Endpoint.create(domainId, name, password, true);
    }

    public static Endpoint create(String domainId, String name, String password, boolean enabled) throws AppPlatformException, ParseException, Exception {
        return Endpoint.create(domainId, name, password, null, enabled);
    }

    public static Endpoint create(String domainId, String name, String password, String description) throws AppPlatformException, ParseException, Exception {
        return Endpoint.create(domainId, name, password, true, description);
    }

    public static Endpoint create(String domainId, String name, String password, String description, boolean enabled) throws AppPlatformException, ParseException, Exception {
        return Endpoint.create(domainId, name, password, true, description);
    }

    public static Endpoint create(String domainId, String name, String password, boolean enabled, String description) throws AppPlatformException, ParseException, Exception {
        BandwidthClient client = BandwidthClient.getInstance();
        return Endpoint.create(client, domainId, name, password, description, enabled, null);
    }

    public static Endpoint create(BandwidthClient client, String domainId, String name, String password, String description, boolean enabled, String applicationId) throws AppPlatformException, ParseException, Exception {
        assert (domainId != null);
        assert (name != null);
        assert (password != null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("enabled", Boolean.toString(enabled));
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("password", password);
        params.put("credentials", credentials);
        if (description != null) {
            params.put("description", description);
        }
        if (applicationId != null) {
            params.put("applicationId", applicationId);
        }
        return Endpoint.create(client, domainId, params);
    }

    public static Endpoint create(BandwidthClient client, String domainId, Map<String, Object> params) throws AppPlatformException, ParseException, Exception {
        assert (client != null && params != null);
        String endpointsUri = String.format(client.getUserResourceUri("domains/%s/endpoints"), domainId);
        RestResponse response = client.post(endpointsUri, params);
        if (response.getStatus() > 400) {
            throw new AppPlatformException(response.getResponseText());
        }
        JSONObject callObj = Endpoint.toJSONObject(client.get(response.getLocation(), null));
        return new Endpoint(client, callObj);
    }

    public static Endpoint get(String domainId, String endpointId) throws ParseException, Exception {
        BandwidthClient client = BandwidthClient.getInstance();
        assert (domainId != null);
        assert (endpointId != null);
        String endpointsUri = String.format(client.getUserResourceUri("domains/%s/endpoints"), domainId) + "/" + endpointId;
        JSONObject jsonObject = Endpoint.toJSONObject(client.get(endpointsUri, null));
        return new Endpoint(client, jsonObject);
    }

    public static ResourceList<Endpoint> list(String domainId) {
        return Endpoint.list(domainId, 0, 20);
    }

    public static ResourceList<Endpoint> list(String domainId, int page, int size) {
        assert (domainId != null);
        assert (page >= 0);
        assert (size > 0);
        BandwidthClient client = BandwidthClient.getInstance();
        String resourceUri = String.format(client.getUserResourceUri("domains/%s/endpoints"), domainId);
        ResourceList<Endpoint> endpoints = new ResourceList<Endpoint>(page, size, resourceUri, Endpoint.class);
        endpoints.setClient(client);
        endpoints.initialize();
        return endpoints;
    }

    public static Endpoint update(String domainId, String endpointId, String endpointPassword) throws AppPlatformException, ParseException, Exception {
        return Endpoint.update(domainId, endpointId, endpointPassword, null, false);
    }

    public static Endpoint update(String domainId, String endpointId, String endpointPassword, boolean enabled) throws AppPlatformException, ParseException, Exception {
        return Endpoint.update(domainId, endpointId, endpointPassword, null, enabled);
    }

    public static Endpoint update(String domainId, String endpointId, String endpointPassword, String applicationId, boolean enabled) throws AppPlatformException, ParseException, Exception {
        return Endpoint.update(domainId, endpointId, endpointPassword, applicationId, null, enabled);
    }

    public static Endpoint update(String domainId, String endpointId, String password, String applicationId, String description, boolean enabled) throws AppPlatformException, ParseException, Exception {
        BandwidthClient client = BandwidthClient.getInstance();
        assert (domainId != null);
        assert (endpointId != null);
        assert (password != null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("password", password);
        params.put("credentials", credentials);
        if (applicationId != null) {
            params.put("applicationId", applicationId);
        }
        if (description != null) {
            params.put("description", description);
        }
        params.put("enabled", Boolean.toString(enabled));
        String domainsUri = String.format(client.getUserResourceUri("domains/%s/endpoints"), domainId) + "/" + endpointId;
        RestResponse response = client.post(domainsUri, params);
        if (response.getStatus() > 400) {
            throw new AppPlatformException(response.getResponseText());
        }
        JSONObject jsonObject = Endpoint.toJSONObject(client.get(domainsUri, null));
        return new Endpoint(client, jsonObject);
    }

    public static void delete(String domainId, String endpointId) throws AppPlatformException, IOException {
        assert (endpointId != null);
        BandwidthClient client = BandwidthClient.getInstance();
        RestResponse response = client.delete(String.format(client.getUserResourceUri("domains/%s/endpoints"), domainId) + "/" + endpointId);
        if (response.getStatus() > 400) {
            throw new AppPlatformException(response.getResponseText());
        }
    }

    public static void delete(BandwidthClient client, String domainId, String endpointId) throws AppPlatformException, IOException {
        assert (endpointId != null);
        RestResponse response = client.delete(String.format(client.getUserResourceUri("domains/%s/endpoints"), domainId) + "/" + endpointId);
        if (response.getStatus() > 400) {
            throw new AppPlatformException(response.getResponseText());
        }
    }

    public String getName() {
        return this.getPropertyAsString("name");
    }

    public String getDomainId() {
        return this.getPropertyAsString("domainId");
    }

    public boolean isEnabled() {
        return this.getPropertyAsBoolean("enabled");
    }

    public String getSipUri() {
        return this.getPropertyAsString("sipUri");
    }

    public String getDescription() {
        return this.getPropertyAsString("description");
    }

    public Credentials getCredentials() {
        try {
            return (Credentials)new ObjectMapper().readValue(this.getProperty("credentials").toString(), Credentials.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        return "Endpoint{id='" + this.getId() + '\'' + ", name=" + this.getName() + ", domainId='" + this.getDomainId() + '\'' + ", enabled='" + this.isEnabled() + '\'' + ", sipUri='" + this.getSipUri() + '\'' + ", credentials= {" + this.getCredentials() + '}' + "}";
    }
}

