/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public abstract class ModelBase {
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    protected final Map<String, Object> properties = new HashMap<String, Object>();

    protected void updateProperties(JSONObject jsonObject) {
        if (jsonObject != null) {
            for (Object key : jsonObject.keySet()) {
                this.properties.put(key.toString(), jsonObject.get(key));
            }
        }
    }

    public String getId() {
        return this.getPropertyAsString("id");
    }

    protected String getPropertyAsString(String key) {
        return (String)this.properties.get(key);
    }

    protected String[] getPropertyAsStringArray(String key) {
        if (this.properties.containsKey(key)) {
            List list = (List)this.properties.get(key);
            String[] arr = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                arr[i] = obj.toString();
            }
            return arr;
        }
        return null;
    }

    protected Object getProperty(String key) {
        return this.properties.get(key);
    }

    protected Boolean getPropertyAsBoolean(String key) {
        Object o = this.properties.get(key);
        if (o == null) {
            return null;
        }
        return o instanceof Boolean ? ((Boolean)o).booleanValue() : "true".equals(o.toString());
    }

    protected Long getPropertyAsLong(String key) {
        return (Long)this.properties.get(key);
    }

    protected Double getPropertyAsDouble(String key) {
        Object o = this.properties.get(key);
        return o instanceof Double ? (Double)o : Double.parseDouble(o.toString());
    }

    protected Date getPropertyAsDate(String key) {
        Object o = this.properties.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return new Date((Long)o);
        }
        try {
            return dateFormat.parse(o.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    protected Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.properties.keySet()) {
            map.put(key, this.properties.get(key));
        }
        return map;
    }
}

