/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.sdk.model;

import com.bandwidth.sdk.BandwidthClient;
import com.bandwidth.sdk.RestResponse;
import com.bandwidth.sdk.model.ResourceBase;
import com.bandwidth.sdk.model.ResourceList;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class PhoneNumber
extends ResourceBase {
    public PhoneNumber(BandwidthClient client, JSONObject jsonObject) {
        super(client, jsonObject);
    }

    @Override
    protected void setUp(JSONObject jsonObject) {
        this.id = (String)jsonObject.get((Object)"id");
        this.updateProperties(jsonObject);
    }

    public static PhoneNumber get(String phoneNumberId) throws Exception {
        assert (phoneNumberId != null);
        return PhoneNumber.get(BandwidthClient.getInstance(), phoneNumberId);
    }

    public static PhoneNumber get(BandwidthClient client, String phoneNumberId) throws Exception {
        assert (client != null && phoneNumberId != null);
        String phoneNumberUri = client.getUserResourceInstanceUri("phoneNumbers", phoneNumberId);
        JSONObject phoneNumberObj = PhoneNumber.toJSONObject(client.get(phoneNumberUri, null));
        PhoneNumber number = new PhoneNumber(client, phoneNumberObj);
        return number;
    }

    public static PhoneNumber create(Map<String, Object> params) throws Exception {
        return PhoneNumber.create(BandwidthClient.getInstance(), params);
    }

    public static PhoneNumber create(BandwidthClient client, Map<String, Object> params) throws Exception {
        String uri = client.getUserResourceUri("phoneNumbers");
        RestResponse createResponse = client.post(uri, params);
        RestResponse getResponse = client.get(createResponse.getLocation(), null);
        JSONObject jsonObject = PhoneNumber.toJSONObject(getResponse);
        return new PhoneNumber(client, jsonObject);
    }

    public static ResourceList<PhoneNumber> list() throws IOException {
        return PhoneNumber.list(0, 25);
    }

    public static ResourceList<PhoneNumber> list(int page, int size) throws IOException {
        return PhoneNumber.list(BandwidthClient.getInstance(), page, size);
    }

    public static ResourceList<PhoneNumber> list(BandwidthClient client, int page, int size) throws IOException {
        String resourceUri = client.getUserResourceUri("phoneNumbers");
        ResourceList<PhoneNumber> phoneNumbers = new ResourceList<PhoneNumber>(page, size, resourceUri, PhoneNumber.class);
        phoneNumbers.setClient(client);
        phoneNumbers.initialize();
        return phoneNumbers;
    }

    public String getUri() {
        return this.client.getUserResourceInstanceUri("phoneNumbers", this.getId());
    }

    public void commit() throws Exception {
        String fallbackNumber;
        String name;
        HashMap<String, Object> params = new HashMap<String, Object>();
        String applicationId = this.getPropertyAsString("applicationId");
        if (applicationId != null) {
            params.put("applicationId", applicationId);
        }
        if ((name = this.getName()) != null) {
            params.put("name", name);
        }
        if ((fallbackNumber = this.getFallbackNumber()) != null) {
            params.put("fallbackNumber", fallbackNumber);
        }
        String uri = this.getUri();
        this.client.post(uri, params);
        JSONObject object = PhoneNumber.toJSONObject(this.client.get(uri, null));
        this.updateProperties(object);
    }

    public void delete() throws IOException {
        this.client.delete(this.getUri());
    }

    public String getApplication() {
        return this.getPropertyAsString("application");
    }

    public String getNumber() {
        return this.getPropertyAsString("number");
    }

    public String getNationalNumber() {
        return this.getPropertyAsString("nationalNumber");
    }

    public String getName() {
        return this.getPropertyAsString("name");
    }

    public String getCity() {
        return this.getPropertyAsString("city");
    }

    public String getState() {
        return this.getPropertyAsString("state");
    }

    public String getNumberState() {
        return this.getPropertyAsString("numberState");
    }

    public String getFallbackNumber() {
        return this.getPropertyAsString("fallbackNumber");
    }

    public Double getPrice() {
        return this.getPropertyAsDouble("price");
    }

    public Date getCreatedTime() {
        return this.getPropertyAsDate("createdTime");
    }

    public void setApplicationId(String applicationId) {
        this.putProperty("applicationId", applicationId);
    }

    public void setName(String name) {
        this.putProperty("name", name);
    }

    public void setFallbackNumber(String fallbackNumber) {
        this.putProperty("fallbackNumber", fallbackNumber);
    }

    public String toString() {
        return "PhoneNumber{id='" + this.getId() + '\'' + ", application='" + this.getApplication() + '\'' + ", number='" + this.getNumber() + '\'' + ", nationalNumber='" + this.getNationalNumber() + '\'' + ", name='" + this.getName() + '\'' + ", city='" + this.getCity() + '\'' + ", state='" + this.getState() + '\'' + ", numberState='" + this.getNumberState() + '\'' + ", fallbackNumber='" + this.getFallbackNumber() + '\'' + ", price=" + this.getPrice() + ", createdTime=" + this.getCreatedTime() + '}';
    }
}

