/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth;

import com.bandwidth.exceptions.ApiException;
import com.bandwidth.http.request.MultipartFileWrapper;
import com.bandwidth.http.request.MultipartWrapper;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiHelper {
    public static ObjectMapper mapper = new ObjectMapper(){
        private static final long serialVersionUID = -174113593500315394L;
        {
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    };
    private static final Set<Object> WRAPPER_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, String.class, Integer.class, Long.class, Float.class, Double.class, Void.class, File.class, MultipartWrapper.class, MultipartFileWrapper.class));

    private static JsonSerializer getSerializer(JsonSerialize serializerAnnotation) {
        try {
            return (JsonSerializer)serializerAnnotation.using().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String serialize(Object obj) throws JsonProcessingException {
        if (obj == null) {
            return null;
        }
        return mapper.writeValueAsString(obj);
    }

    public static String serialize(Object obj, final JsonSerializer serializer) throws JsonProcessingException {
        if (obj == null || serializer == null) {
            return null;
        }
        if (obj.getClass().getName().equals("java.util.ArrayList")) {
            final Class<?> cls = ((ArrayList)obj).get(0).getClass();
            return new ObjectMapper(){
                private static final long serialVersionUID = -1639089569991988232L;
                {
                    SimpleModule module = new SimpleModule();
                    module.addSerializer(cls, serializer);
                    this.registerModule((Module)module);
                }
            }.writeValueAsString(obj);
        }
        final Class<?> cls = obj.getClass();
        return new ObjectMapper(){
            private static final long serialVersionUID = -1639089569991988232L;
            {
                SimpleModule module = new SimpleModule();
                module.addSerializer(cls, serializer);
                this.registerModule((Module)module);
            }
        }.writeValueAsString(obj);
    }

    public static <T> List<T> deserialize(String json, TypeReference<List<T>> typeReference, final Class<T> cls, final JsonDeserializer<T> deserializer) throws IOException {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (List)new ObjectMapper(){
            private static final long serialVersionUID = -1639089569991988232L;
            {
                SimpleModule module = new SimpleModule();
                module.addDeserializer(cls, deserializer);
                this.registerModule((Module)module);
            }
        }.readValue(json, typeReference);
    }

    public static <T> T deserialize(String json, Class<T> clazz) throws IOException {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (T)mapper.readValue(json, clazz);
    }

    public static <T> List<T> deserializeArray(String json, Class<T[]> classArray) throws IOException {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return Arrays.asList((Object[])mapper.readValue(json, classArray));
    }

    public static void populate(String json, ApiException obj) throws IOException {
        if (!ApiHelper.isNullOrWhiteSpace(json)) {
            mapper.readerForUpdating((Object)obj).readValue(json);
        }
    }

    public static LinkedHashMap<String, Object> deserialize(String json) throws IOException {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
        return ApiHelper.deserialize(json, typeRef);
    }

    public static <T> T deserialize(String json, TypeReference<T> typeReference) throws IOException {
        if (ApiHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (T)mapper.readValue(json, typeReference);
    }

    public static void appendUrlWithTemplateParameters(StringBuilder queryBuilder, Map<String, AbstractMap.SimpleEntry<Object, Boolean>> parameters) {
        if (null == queryBuilder) {
            throw new IllegalArgumentException("Given value for parameter \"queryBuilder\" is invalid.");
        }
        if (null == parameters) {
            return;
        }
        for (Map.Entry<String, AbstractMap.SimpleEntry<Object, Boolean>> pair : parameters.entrySet()) {
            String replaceValue = "";
            Object element = pair.getValue().getKey();
            boolean shouldEncode = pair.getValue().getValue();
            replaceValue = null == element ? "" : (element instanceof Collection ? ApiHelper.flattenCollection("", (Collection)element, shouldEncode, "%s%s%s", '/') : (shouldEncode ? ApiHelper.tryUrlEncode(element.toString()) : element.toString()));
            ApiHelper.replaceAll(queryBuilder, "{" + pair.getKey() + "}", replaceValue);
        }
    }

    public static void appendUrlWithQueryParameters(StringBuilder queryBuilder, Map<String, Object> parameters) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("Given value for parameter \"queryBuilder\" is invalid.");
        }
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        boolean hasParams = queryBuilder.indexOf("?") > 0;
        queryBuilder.append(hasParams ? (char)'&' : '?');
        ApiHelper.encodeObjectAsQueryString("", parameters, queryBuilder);
    }

    public static boolean isNullOrWhiteSpace(String s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        if (length > 0) {
            int start = 0;
            int middle = length / 2;
            int end = length - 1;
            while (start <= middle) {
                if (s.charAt(start) > ' ' || s.charAt(end) > ' ') {
                    return false;
                }
                ++start;
                --end;
            }
            return true;
        }
        return false;
    }

    public static void replaceAll(StringBuilder stringBuilder, String toReplace, String replaceWith) {
        int index = stringBuilder.indexOf(toReplace);
        while (index != -1) {
            stringBuilder.replace(index, index + toReplace.length(), replaceWith);
            index += replaceWith.length();
            index = stringBuilder.indexOf(toReplace, index);
        }
    }

    public static void removeNullValues(Map<String, ?> map) {
        if (map == null) {
            return;
        }
        map.values().removeAll(Collections.singleton(null));
    }

    public static String cleanUrl(StringBuilder url) {
        Pattern pattern = Pattern.compile("^(https?://[^/]+)");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid Url format.");
        }
        String protocol = matcher.group(1);
        String query = url.substring(protocol.length());
        query = query.replaceAll("//+", "/");
        return protocol.concat(query);
    }

    public static List<AbstractMap.SimpleEntry<String, Object>> prepareFormFields(Map<?, ?> value) {
        ArrayList<AbstractMap.SimpleEntry<String, Object>> formFields = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
        if (value != null) {
            ApiHelper.objectToList("", value, formFields, new HashSet<Integer>());
        }
        return formFields;
    }

    private static void encodeObjectAsQueryString(String name, Object obj, StringBuilder objBuilder) {
        if (obj == null) {
            return;
        }
        ArrayList<AbstractMap.SimpleEntry<String, Object>> objectList = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
        ApiHelper.objectToList(name, obj, objectList, new HashSet<Integer>());
        boolean hasParam = false;
        for (AbstractMap.SimpleEntry simpleEntry : objectList) {
            String accessor = (String)simpleEntry.getKey();
            Object value = simpleEntry.getValue();
            if (value == null) continue;
            hasParam = true;
            String paramKeyValPair = String.format("%s=%s&", accessor, ApiHelper.tryUrlEncode(value.toString()));
            objBuilder.append(paramKeyValPair);
        }
        if (hasParam) {
            objBuilder.setLength(objBuilder.length() - 1);
        }
    }

    private static String flattenCollection(String elemName, Collection<?> array, boolean encode, String fmt, char separator) {
        StringBuilder builder = new StringBuilder();
        for (Object element : array) {
            String elemValue = null;
            elemValue = element == null ? "" : element.toString();
            if (encode) {
                elemValue = ApiHelper.tryUrlEncode(elemValue);
            }
            builder.append(String.format(fmt, elemName, elemValue, Character.valueOf(separator)));
        }
        if (builder.length() > 1 && builder.charAt(builder.length() - 1) == separator) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static String tryUrlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return value;
        }
    }

    private static void objectToList(String objName, Collection<?> obj, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed) {
        Collection<?> array = obj;
        int index = 0;
        for (Object element : array) {
            String key = String.format("%s[%d]", objName, index++);
            ApiHelper.loadKeyValuePairForEncoding(key, element, objectList, processed);
        }
    }

    private static void objectToList(String objName, Map<?, ?> obj, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed) {
        Map<?, ?> map = obj;
        for (Map.Entry<?, ?> pair : map.entrySet()) {
            String attribName = pair.getKey().toString();
            if (objName != null && !objName.isEmpty()) {
                attribName = String.format("%s[%s]", objName, attribName);
            }
            ApiHelper.loadKeyValuePairForEncoding(attribName, pair.getValue(), objectList, processed);
        }
    }

    private static void objectToList(String objName, Object obj, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed) {
        if (obj == null) {
            return;
        }
        if (!ApiHelper.isWrapperType(obj.getClass())) {
            if (processed.contains(objName.hashCode())) {
                return;
            }
            processed.add(objName.hashCode());
        }
        if (obj instanceof Collection) {
            ApiHelper.objectToList(objName, (Collection)obj, objectList, processed);
        } else if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            int index = 0;
            for (Object element : array) {
                String key = String.format("%s[%d]", objName, index++);
                ApiHelper.loadKeyValuePairForEncoding(key, element, objectList, processed);
            }
        } else if (obj instanceof Map) {
            ApiHelper.objectToList(objName, (Map)obj, objectList, processed);
        } else {
            Method[] methods;
            for (Method method : methods = obj.getClass().getMethods()) {
                JsonGetter getterAnnotation;
                if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") || (getterAnnotation = method.getAnnotation(JsonGetter.class)) == null) continue;
                String attribName = getterAnnotation.value();
                if (objName != null && !objName.isEmpty()) {
                    attribName = String.format("%s[%s]", objName, attribName);
                }
                try {
                    Object value = method.invoke(obj, new Object[0]);
                    JsonSerialize serializerAnnotation = method.getAnnotation(JsonSerialize.class);
                    if (serializerAnnotation != null) {
                        ApiHelper.loadKeyValuePairForEncoding(attribName, value, objectList, processed, serializerAnnotation);
                        continue;
                    }
                    ApiHelper.loadKeyValuePairForEncoding(attribName, value, objectList, processed);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void loadKeyValuePairForEncoding(String key, Object value, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed) {
        if (value == null) {
            return;
        }
        if (ApiHelper.isWrapperType(value)) {
            objectList.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
        } else if (value instanceof UUID) {
            objectList.add(new AbstractMap.SimpleEntry<String, String>(key, value.toString()));
        } else {
            ApiHelper.objectToList(key, value, objectList, processed);
        }
    }

    private static void loadKeyValuePairForEncoding(String key, Object value, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed, JsonSerialize serializerAnnotation) {
        if (value == null) {
            return;
        }
        try {
            value = ApiHelper.serialize(value, ApiHelper.getSerializer(serializerAnnotation));
            if (value.toString().startsWith("\"")) {
                value = value.toString().substring(1, value.toString().length() - 1);
            }
            objectList.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private static boolean isWrapperType(Object object) {
        return WRAPPER_TYPES.contains(object.getClass()) || object.getClass().isPrimitive() || object.getClass().isEnum();
    }
}

