/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth;

import com.bandwidth.ApiHelper;
import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.Environment;
import com.bandwidth.MessagingBasicAuthCredentials;
import com.bandwidth.MessagingBasicAuthManager;
import com.bandwidth.MessagingClient;
import com.bandwidth.Server;
import com.bandwidth.TwoFactorAuthBasicAuthCredentials;
import com.bandwidth.TwoFactorAuthBasicAuthManager;
import com.bandwidth.TwoFactorAuthClient;
import com.bandwidth.VoiceBasicAuthCredentials;
import com.bandwidth.VoiceBasicAuthManager;
import com.bandwidth.VoiceClient;
import com.bandwidth.WebRtcBasicAuthCredentials;
import com.bandwidth.WebRtcBasicAuthManager;
import com.bandwidth.WebRtcClient;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpClientConfiguration;
import com.bandwidth.http.client.OkClient;
import com.bandwidth.http.client.ReadonlyHttpClientConfiguration;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public final class BandwidthClient
implements Configuration {
    private MessagingClient messagingClient;
    private TwoFactorAuthClient twoFactorAuthClient;
    private VoiceClient voiceClient;
    private WebRtcClient webRtcClient;
    private final Environment environment;
    private final String baseUrl;
    private final HttpClient httpClient;
    private final long timeout;
    private final ReadonlyHttpClientConfiguration httpClientConfig;
    private Map<String, AuthManager> authManagers;
    private MessagingBasicAuthManager messagingBasicAuthManager;
    private TwoFactorAuthBasicAuthManager twoFactorAuthBasicAuthManager;
    private VoiceBasicAuthManager voiceBasicAuthManager;
    private WebRtcBasicAuthManager webRtcBasicAuthManager;

    public MessagingClient getMessagingClient() {
        return this.messagingClient;
    }

    public TwoFactorAuthClient getTwoFactorAuthClient() {
        return this.twoFactorAuthClient;
    }

    public VoiceClient getVoiceClient() {
        return this.voiceClient;
    }

    public WebRtcClient getWebRtcClient() {
        return this.webRtcClient;
    }

    public static void shutdown() {
        OkClient.shutdown();
    }

    private BandwidthClient(Environment environment, String baseUrl, String messagingBasicAuthUserName, String messagingBasicAuthPassword, String twoFactorAuthBasicAuthUserName, String twoFactorAuthBasicAuthPassword, String voiceBasicAuthUserName, String voiceBasicAuthPassword, String webRtcBasicAuthUserName, String webRtcBasicAuthPassword, HttpClient httpClient, long timeout, ReadonlyHttpClientConfiguration httpClientConfig, Map<String, AuthManager> authManagers) {
        this.environment = environment;
        this.baseUrl = baseUrl;
        this.httpClient = httpClient;
        this.timeout = timeout;
        this.httpClientConfig = httpClientConfig;
        Map<String, AuthManager> map = this.authManagers = authManagers == null ? new HashMap<String, AuthManager>() : new HashMap<String, AuthManager>(authManagers);
        if (this.authManagers.containsKey("messaging")) {
            this.messagingBasicAuthManager = (MessagingBasicAuthManager)this.authManagers.get("messaging");
        }
        if (!this.authManagers.containsKey("messaging") || this.getMessagingBasicAuthCredentials().getMessagingBasicAuthUserName() != messagingBasicAuthUserName || this.getMessagingBasicAuthCredentials().getMessagingBasicAuthPassword() != messagingBasicAuthPassword) {
            this.messagingBasicAuthManager = new MessagingBasicAuthManager(messagingBasicAuthUserName, messagingBasicAuthPassword);
            this.authManagers.put("messaging", this.messagingBasicAuthManager);
        }
        if (this.authManagers.containsKey("twoFactorAuth")) {
            this.twoFactorAuthBasicAuthManager = (TwoFactorAuthBasicAuthManager)this.authManagers.get("twoFactorAuth");
        }
        if (!this.authManagers.containsKey("twoFactorAuth") || this.getTwoFactorAuthBasicAuthCredentials().getTwoFactorAuthBasicAuthUserName() != twoFactorAuthBasicAuthUserName || this.getTwoFactorAuthBasicAuthCredentials().getTwoFactorAuthBasicAuthPassword() != twoFactorAuthBasicAuthPassword) {
            this.twoFactorAuthBasicAuthManager = new TwoFactorAuthBasicAuthManager(twoFactorAuthBasicAuthUserName, twoFactorAuthBasicAuthPassword);
            this.authManagers.put("twoFactorAuth", this.twoFactorAuthBasicAuthManager);
        }
        if (this.authManagers.containsKey("voice")) {
            this.voiceBasicAuthManager = (VoiceBasicAuthManager)this.authManagers.get("voice");
        }
        if (!this.authManagers.containsKey("voice") || this.getVoiceBasicAuthCredentials().getVoiceBasicAuthUserName() != voiceBasicAuthUserName || this.getVoiceBasicAuthCredentials().getVoiceBasicAuthPassword() != voiceBasicAuthPassword) {
            this.voiceBasicAuthManager = new VoiceBasicAuthManager(voiceBasicAuthUserName, voiceBasicAuthPassword);
            this.authManagers.put("voice", this.voiceBasicAuthManager);
        }
        if (this.authManagers.containsKey("webRtc")) {
            this.webRtcBasicAuthManager = (WebRtcBasicAuthManager)this.authManagers.get("webRtc");
        }
        if (!this.authManagers.containsKey("webRtc") || this.getWebRtcBasicAuthCredentials().getWebRtcBasicAuthUserName() != webRtcBasicAuthUserName || this.getWebRtcBasicAuthCredentials().getWebRtcBasicAuthPassword() != webRtcBasicAuthPassword) {
            this.webRtcBasicAuthManager = new WebRtcBasicAuthManager(webRtcBasicAuthUserName, webRtcBasicAuthPassword);
            this.authManagers.put("webRtc", this.webRtcBasicAuthManager);
        }
        this.messagingClient = new MessagingClient(this);
        this.twoFactorAuthClient = new TwoFactorAuthClient(this);
        this.voiceClient = new VoiceClient(this);
        this.webRtcClient = new WebRtcClient(this);
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public ReadonlyHttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    private String getMessagingBasicAuthUserName() {
        return this.getMessagingBasicAuthCredentials().getMessagingBasicAuthUserName();
    }

    private String getMessagingBasicAuthPassword() {
        return this.getMessagingBasicAuthCredentials().getMessagingBasicAuthPassword();
    }

    @Override
    public MessagingBasicAuthCredentials getMessagingBasicAuthCredentials() {
        return this.messagingBasicAuthManager;
    }

    private String getTwoFactorAuthBasicAuthUserName() {
        return this.getTwoFactorAuthBasicAuthCredentials().getTwoFactorAuthBasicAuthUserName();
    }

    private String getTwoFactorAuthBasicAuthPassword() {
        return this.getTwoFactorAuthBasicAuthCredentials().getTwoFactorAuthBasicAuthPassword();
    }

    @Override
    public TwoFactorAuthBasicAuthCredentials getTwoFactorAuthBasicAuthCredentials() {
        return this.twoFactorAuthBasicAuthManager;
    }

    private String getVoiceBasicAuthUserName() {
        return this.getVoiceBasicAuthCredentials().getVoiceBasicAuthUserName();
    }

    private String getVoiceBasicAuthPassword() {
        return this.getVoiceBasicAuthCredentials().getVoiceBasicAuthPassword();
    }

    @Override
    public VoiceBasicAuthCredentials getVoiceBasicAuthCredentials() {
        return this.voiceBasicAuthManager;
    }

    private String getWebRtcBasicAuthUserName() {
        return this.getWebRtcBasicAuthCredentials().getWebRtcBasicAuthUserName();
    }

    private String getWebRtcBasicAuthPassword() {
        return this.getWebRtcBasicAuthCredentials().getWebRtcBasicAuthPassword();
    }

    @Override
    public WebRtcBasicAuthCredentials getWebRtcBasicAuthCredentials() {
        return this.webRtcBasicAuthManager;
    }

    public Map<String, AuthManager> getAuthManagers() {
        return this.authManagers;
    }

    @Override
    public String getBaseUri(Server server) {
        StringBuilder baseUrl = new StringBuilder(BandwidthClient.environmentMapper(this.environment, server));
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> parameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        parameters.put("base_url", new AbstractMap.SimpleEntry<String, Boolean>(this.baseUrl, false));
        ApiHelper.appendUrlWithTemplateParameters(baseUrl, parameters);
        return baseUrl.toString();
    }

    @Override
    public String getBaseUri() {
        return this.getBaseUri(Server.ENUM_DEFAULT);
    }

    private static String environmentMapper(Environment environment, Server server) {
        if (environment.equals((Object)Environment.PRODUCTION)) {
            if (server.equals((Object)Server.ENUM_DEFAULT)) {
                return "api.bandwidth.com";
            }
            if (server.equals((Object)Server.MESSAGINGDEFAULT)) {
                return "https://messaging.bandwidth.com/api/v2";
            }
            if (server.equals((Object)Server.TWOFACTORAUTHDEFAULT)) {
                return "https://mfa.bandwidth.com/api/v1/";
            }
            if (server.equals((Object)Server.VOICEDEFAULT)) {
                return "https://voice.bandwidth.com";
            }
            if (server.equals((Object)Server.WEBRTCDEFAULT)) {
                return "https://api.webrtc.bandwidth.com/v1";
            }
        }
        if (environment.equals((Object)Environment.CUSTOM)) {
            if (server.equals((Object)Server.ENUM_DEFAULT)) {
                return "{base_url}";
            }
            if (server.equals((Object)Server.MESSAGINGDEFAULT)) {
                return "{base_url}";
            }
            if (server.equals((Object)Server.TWOFACTORAUTHDEFAULT)) {
                return "{base_url}";
            }
            if (server.equals((Object)Server.VOICEDEFAULT)) {
                return "{base_url}";
            }
            if (server.equals((Object)Server.WEBRTCDEFAULT)) {
                return "{base_url}";
            }
        }
        return "api.bandwidth.com";
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.environment = this.getEnvironment();
        builder.baseUrl = this.getBaseUrl();
        builder.messagingBasicAuthUserName = this.getMessagingBasicAuthUserName();
        builder.messagingBasicAuthPassword = this.getMessagingBasicAuthPassword();
        builder.twoFactorAuthBasicAuthUserName = this.getTwoFactorAuthBasicAuthUserName();
        builder.twoFactorAuthBasicAuthPassword = this.getTwoFactorAuthBasicAuthPassword();
        builder.voiceBasicAuthUserName = this.getVoiceBasicAuthUserName();
        builder.voiceBasicAuthPassword = this.getVoiceBasicAuthPassword();
        builder.webRtcBasicAuthUserName = this.getWebRtcBasicAuthUserName();
        builder.webRtcBasicAuthPassword = this.getWebRtcBasicAuthPassword();
        builder.httpClient = this.getHttpClient();
        builder.timeout = this.getTimeout();
        builder.authManagers = this.authManagers;
        builder.setHttpClientConfig(this.httpClientConfig);
        return builder;
    }

    public static class Builder {
        private Environment environment = Environment.PRODUCTION;
        private String baseUrl = "https://www.example.com";
        private String messagingBasicAuthUserName = "TODO: Replace";
        private String messagingBasicAuthPassword = "TODO: Replace";
        private String twoFactorAuthBasicAuthUserName = "TODO: Replace";
        private String twoFactorAuthBasicAuthPassword = "TODO: Replace";
        private String voiceBasicAuthUserName = "TODO: Replace";
        private String voiceBasicAuthPassword = "TODO: Replace";
        private String webRtcBasicAuthUserName = "TODO: Replace";
        private String webRtcBasicAuthPassword = "TODO: Replace";
        private HttpClient httpClient;
        private long timeout = 0L;
        private Map<String, AuthManager> authManagers = null;
        private HttpClientConfiguration httpClientConfig;

        public Builder messagingBasicAuthCredentials(String messagingBasicAuthUserName, String messagingBasicAuthPassword) {
            if (messagingBasicAuthUserName == null) {
                throw new NullPointerException("Username cannot be null.");
            }
            if (messagingBasicAuthPassword == null) {
                throw new NullPointerException("Password cannot be null.");
            }
            this.messagingBasicAuthUserName = messagingBasicAuthUserName;
            this.messagingBasicAuthPassword = messagingBasicAuthPassword;
            return this;
        }

        public Builder twoFactorAuthBasicAuthCredentials(String twoFactorAuthBasicAuthUserName, String twoFactorAuthBasicAuthPassword) {
            if (twoFactorAuthBasicAuthUserName == null) {
                throw new NullPointerException("Username cannot be null.");
            }
            if (twoFactorAuthBasicAuthPassword == null) {
                throw new NullPointerException("Password cannot be null.");
            }
            this.twoFactorAuthBasicAuthUserName = twoFactorAuthBasicAuthUserName;
            this.twoFactorAuthBasicAuthPassword = twoFactorAuthBasicAuthPassword;
            return this;
        }

        public Builder voiceBasicAuthCredentials(String voiceBasicAuthUserName, String voiceBasicAuthPassword) {
            if (voiceBasicAuthUserName == null) {
                throw new NullPointerException("Username cannot be null.");
            }
            if (voiceBasicAuthPassword == null) {
                throw new NullPointerException("Password cannot be null.");
            }
            this.voiceBasicAuthUserName = voiceBasicAuthUserName;
            this.voiceBasicAuthPassword = voiceBasicAuthPassword;
            return this;
        }

        public Builder webRtcBasicAuthCredentials(String webRtcBasicAuthUserName, String webRtcBasicAuthPassword) {
            if (webRtcBasicAuthUserName == null) {
                throw new NullPointerException("Username cannot be null.");
            }
            if (webRtcBasicAuthPassword == null) {
                throw new NullPointerException("Password cannot be null.");
            }
            this.webRtcBasicAuthUserName = webRtcBasicAuthUserName;
            this.webRtcBasicAuthPassword = webRtcBasicAuthPassword;
            return this;
        }

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder timeout(long timeout) {
            if (timeout > 0L) {
                this.timeout = timeout;
            }
            return this;
        }

        private void setHttpClientConfig(ReadonlyHttpClientConfiguration httpClientConfig) {
            this.timeout = httpClientConfig.getTimeout();
        }

        public BandwidthClient build() {
            this.httpClientConfig = new HttpClientConfiguration();
            this.httpClientConfig.setTimeout(this.timeout);
            this.httpClient = new OkClient(this.httpClientConfig);
            return new BandwidthClient(this.environment, this.baseUrl, this.messagingBasicAuthUserName, this.messagingBasicAuthPassword, this.twoFactorAuthBasicAuthUserName, this.twoFactorAuthBasicAuthPassword, this.voiceBasicAuthUserName, this.voiceBasicAuthPassword, this.webRtcBasicAuthUserName, this.webRtcBasicAuthPassword, this.httpClient, this.timeout, this.httpClientConfig, this.authManagers);
        }
    }
}

