/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeHelper {
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z");

    public static LocalDateTime fromUnixTimestamp(Long date) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(date), ZoneId.systemDefault());
    }

    public static LocalDateTime fromUnixTimestamp(String date) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(date)), ZoneId.systemDefault());
    }

    public static String toUnixTimestamp(LocalDateTime value) {
        return Long.toString(value.toEpochSecond(ZoneOffset.UTC));
    }

    public static List<String> toUnixTimestamp(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDateTime value : values) {
            valuesAsString.add(DateTimeHelper.toUnixTimestamp(value));
        }
        return valuesAsString;
    }

    public static LocalDateTime fromRfc1123DateTime(String date) {
        return LocalDateTime.parse(date, RFC1123_DATE_TIME_FORMATTER);
    }

    public static String toRfc1123DateTime(LocalDateTime value) {
        return RFC1123_DATE_TIME_FORMATTER.format(value.atZone(ZoneId.of("GMT")));
    }

    public static List<String> toRfc1123DateTime(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDateTime value : values) {
            valuesAsString.add(DateTimeHelper.toRfc1123DateTime(value));
        }
        return valuesAsString;
    }

    public static LocalDateTime fromRfc8601DateTime(String date) {
        Pattern pattern = Pattern.compile("(Z|([+-])(\\d{2}:\\d{2}))$");
        Matcher patternMatcher = pattern.matcher(date);
        if (patternMatcher.find()) {
            OffsetDateTime parsed = OffsetDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
            return LocalDateTime.from(parsed.withOffsetSameInstant(ZoneOffset.UTC));
        }
        return LocalDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
    }

    public static String toRfc8601DateTime(LocalDateTime value) {
        return value.toString() + "Z";
    }

    public static List<String> toRfc8601DateTime(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDateTime value : values) {
            valuesAsString.add(DateTimeHelper.toRfc8601DateTime(value));
        }
        return valuesAsString;
    }

    public static LocalDate fromSimpleDate(String date) {
        return LocalDate.parse(date);
    }

    public static String toSimpleDate(LocalDate value) {
        return value.toString();
    }

    public static List<String> toSimpleDate(List<LocalDate> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDate value : values) {
            valuesAsString.add(DateTimeHelper.toSimpleDate(value));
        }
        return valuesAsString;
    }

    public static class SimpleDateSerializer
    extends JsonSerializer<LocalDate> {
        public void serialize(LocalDate value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(DateTimeHelper.toSimpleDate(value));
        }
    }

    public static class SimpleDateDeserializer
    extends JsonDeserializer<LocalDate> {
        public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateTimeHelper.fromSimpleDate(jp.getValueAsString());
        }
    }

    public static class Rfc8601DateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(DateTimeHelper.toRfc8601DateTime(value));
        }
    }

    public static class Rfc8601DateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateTimeHelper.fromRfc8601DateTime(jp.getValueAsString());
        }
    }

    public static class Rfc1123DateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(DateTimeHelper.toRfc1123DateTime(value));
        }
    }

    public static class Rfc1123DateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateTimeHelper.fromRfc1123DateTime(jp.getValueAsString());
        }
    }

    public static class UnixTimestampSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNumber(DateTimeHelper.toUnixTimestamp(value));
        }
    }

    public static class UnixTimestampDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateTimeHelper.fromUnixTimestamp(jp.getValueAsString());
        }
    }
}

