/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth;

import com.bandwidth.AuthManager;
import com.bandwidth.MessagingBasicAuthCredentials;
import com.bandwidth.http.request.HttpRequest;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;

public class MessagingBasicAuthManager
implements AuthManager,
MessagingBasicAuthCredentials {
    private String username;
    private String password;

    public MessagingBasicAuthManager(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public HttpRequest apply(HttpRequest httpRequest) {
        String authCredentials = this.username + ":" + this.password;
        httpRequest.getHeaders().add("Authorization", "Basic " + Base64.getEncoder().encodeToString(authCredentials.getBytes()));
        return httpRequest;
    }

    @Override
    public CompletableFuture<HttpRequest> applyAsync(HttpRequest httpRequest) {
        String authCredentials = this.username + ":" + this.password;
        httpRequest.getHeaders().add("Authorization", "Basic " + Base64.getEncoder().encodeToString(authCredentials.getBytes()));
        return CompletableFuture.completedFuture(httpRequest);
    }

    @Override
    public String getMessagingBasicAuthUserName() {
        return this.username;
    }

    @Override
    public String getMessagingBasicAuthPassword() {
        return this.password;
    }
}

