/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.http.client;

import java.io.IOException;
import java.net.ProtocolException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HttpRedirectInterceptor
implements Interceptor {
    private static final int MAX_FOLLOW_UPS = 20;
    private boolean followSslRedirects;

    public HttpRedirectInterceptor(boolean followSslRedirects) {
        this.followSslRedirects = followSslRedirects;
    }

    public Response intercept(Interceptor.Chain it) throws IOException {
        Request request = it.request();
        Response response = it.proceed(request);
        int followUpCount = 0;
        while (response.code() == 307 || response.code() == 308) {
            if (++followUpCount > 20) {
                throw new ProtocolException("Too many follow-up requests: " + followUpCount);
            }
            String location = response.header("Location");
            if (location == null) {
                return response;
            }
            HttpUrl followUpUrl = request.url().resolve(location);
            boolean sameScheme = followUpUrl.scheme().equals(response.request().url().scheme());
            if (!sameScheme && !this.followSslRedirects) {
                return null;
            }
            Request.Builder followUpRequestBuilder = request.newBuilder().url(followUpUrl);
            if (!HttpRedirectInterceptor.sameConnection(request.url(), followUpUrl)) {
                followUpRequestBuilder.removeHeader("Authorization");
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (RuntimeException rethrown) {
                    throw rethrown;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            response = it.proceed(followUpRequestBuilder.build());
        }
        return response;
    }

    private static boolean sameConnection(HttpUrl a, HttpUrl b) {
        return a.host().equals(b.host()) && a.port() == b.port() && a.scheme().equals(b.scheme());
    }
}

