/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.http.client;

import com.bandwidth.ApiHelper;
import com.bandwidth.http.Headers;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpClientConfiguration;
import com.bandwidth.http.client.HttpRedirectInterceptor;
import com.bandwidth.http.request.HttpBodyRequest;
import com.bandwidth.http.request.HttpMethod;
import com.bandwidth.http.request.HttpRequest;
import com.bandwidth.http.request.MultipartFileWrapper;
import com.bandwidth.http.request.MultipartWrapper;
import com.bandwidth.http.response.HttpResponse;
import com.bandwidth.http.response.HttpStringResponse;
import com.bandwidth.utilities.FileWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkClient
implements HttpClient {
    private static final Object syncObject = new Object();
    private static volatile OkHttpClient defaultOkHttpClient;
    private OkHttpClient client;

    public OkClient(HttpClientConfiguration httpClientConfig) {
        OkHttpClient.Builder clientBuilder = this.getDefaultOkHttpClient().newBuilder();
        clientBuilder.callTimeout(httpClientConfig.getTimeout(), TimeUnit.SECONDS);
        this.client = clientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OkHttpClient getDefaultOkHttpClient() {
        if (defaultOkHttpClient == null) {
            Object object = syncObject;
            synchronized (object) {
                if (defaultOkHttpClient == null) {
                    defaultOkHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new HttpRedirectInterceptor(true)).retryOnConnectionFailure(true).callTimeout(0L, TimeUnit.SECONDS).build();
                }
            }
        }
        return defaultOkHttpClient;
    }

    public static void shutdown() {
        if (defaultOkHttpClient != null) {
            defaultOkHttpClient.dispatcher().executorService().shutdown();
            defaultOkHttpClient.connectionPool().evictAll();
        }
    }

    @Override
    public CompletableFuture<HttpResponse> executeAsStringAsync(final HttpRequest httpRequest) {
        Request okHttpRequest = OkClient.convertRequest(httpRequest);
        final CompletableFuture<HttpResponse> callBack = new CompletableFuture<HttpResponse>();
        this.client.newCall(okHttpRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                try {
                    OkClient.publishResponse(null, httpRequest, callBack, e, false);
                }
                catch (IOException ex) {
                    callBack.completeExceptionally(ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response okHttpResponse) throws IOException {
                try {
                    OkClient.publishResponse(okHttpResponse, httpRequest, callBack, null, false);
                }
                catch (IOException ex) {
                    callBack.completeExceptionally(ex);
                }
                finally {
                    okHttpResponse.close();
                }
            }
        });
        return callBack;
    }

    @Override
    public CompletableFuture<HttpResponse> executeAsBinaryAsync(final HttpRequest httpRequest) {
        Request okHttpRequest = OkClient.convertRequest(httpRequest);
        final CompletableFuture<HttpResponse> callBack = new CompletableFuture<HttpResponse>();
        this.client.newCall(okHttpRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                try {
                    OkClient.publishResponse(null, httpRequest, callBack, e, true);
                }
                catch (IOException ex) {
                    callBack.completeExceptionally(ex);
                }
            }

            public void onResponse(Call call, Response okHttpResponse) throws IOException {
                try {
                    OkClient.publishResponse(okHttpResponse, httpRequest, callBack, null, true);
                }
                catch (IOException ex) {
                    callBack.completeExceptionally(ex);
                }
            }
        });
        return callBack;
    }

    @Override
    public HttpResponse executeAsString(HttpRequest httpRequest) throws IOException {
        Request okHttpRequest = OkClient.convertRequest(httpRequest);
        Response okHttpResponse = this.client.newCall(okHttpRequest).execute();
        return OkClient.convertResponse(okHttpResponse, false);
    }

    @Override
    public HttpResponse executeAsBinary(HttpRequest httpRequest) throws IOException {
        Request okHttpRequest = OkClient.convertRequest(httpRequest);
        Response okHttpResponse = this.client.newCall(okHttpRequest).execute();
        return OkClient.convertResponse(okHttpResponse, true);
    }

    private static HttpResponse publishResponse(Response okHttpResponse, HttpRequest httpRequest, CompletableFuture<HttpResponse> completionBlock, Throwable error, boolean binaryResponse) throws IOException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = OkClient.convertResponse(okHttpResponse, binaryResponse);
            if (error == null && httpResponse != null) {
                completionBlock.complete(httpResponse);
            } else {
                completionBlock.completeExceptionally(error);
            }
        }
        catch (IOException e) {
            completionBlock.completeExceptionally(e);
        }
        return httpResponse;
    }

    private static HttpResponse convertResponse(Response response, boolean binaryResponse) throws IOException {
        HttpResponse httpResponse = null;
        if (null == response) {
            return null;
        }
        ResponseBody responseBody = response.body();
        Headers headers = new Headers(response.headers().toMultimap());
        if (binaryResponse) {
            InputStream responseStream = responseBody.byteStream();
            httpResponse = new HttpResponse(response.code(), headers, responseStream);
        } else {
            String responseString = responseBody.string();
            ByteArrayInputStream responseStream = new ByteArrayInputStream(responseString.getBytes());
            httpResponse = new HttpStringResponse(response.code(), headers, responseStream, responseString);
            responseBody.close();
            response.close();
        }
        return httpResponse;
    }

    private static Request convertRequest(HttpRequest httpRequest) {
        RequestBody requestBody;
        if (httpRequest instanceof HttpBodyRequest) {
            String contentType;
            Object body = ((HttpBodyRequest)httpRequest).getBody();
            if (body instanceof FileWrapper) {
                FileWrapper file = (FileWrapper)body;
                if (file.getContentType() != null && !file.getContentType().isEmpty()) {
                    contentType = file.getContentType();
                    httpRequest.getHeaders().add("content-type", contentType);
                } else if (httpRequest.getHeaders().has("content-type")) {
                    contentType = httpRequest.getHeaders().value("content-type");
                } else {
                    contentType = "application/octet-stream";
                    httpRequest.getHeaders().add("content-type", contentType);
                }
                requestBody = RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)((FileWrapper)body).getFile());
            } else {
                if (!httpRequest.getHeaders().has("content-type")) {
                    httpRequest.getHeaders().add("content-type", "application/json; charset=UTF-8");
                }
                contentType = httpRequest.getHeaders().value("content-type");
                requestBody = RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])((String)body).getBytes());
            }
        } else {
            List<AbstractMap.SimpleEntry<String, Object>> parameters = httpRequest.getParameters();
            boolean multipartRequest = false;
            if (parameters != null && parameters.size() > 0) {
                for (AbstractMap.SimpleEntry simpleEntry : parameters) {
                    if (!(simpleEntry.getValue() instanceof MultipartFileWrapper) && !(simpleEntry.getValue() instanceof MultipartWrapper)) continue;
                    multipartRequest = true;
                    break;
                }
                if (multipartRequest) {
                    MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                    for (AbstractMap.SimpleEntry<String, Object> param : parameters) {
                        if (param.getValue() instanceof MultipartFileWrapper) {
                            MultipartFileWrapper wrapperObj = (MultipartFileWrapper)param.getValue();
                            MediaType mediaType = wrapperObj.getFileWrapper().getContentType() != null && !wrapperObj.getFileWrapper().getContentType().isEmpty() ? MediaType.parse((String)wrapperObj.getFileWrapper().getContentType()) : MediaType.parse((String)wrapperObj.getHeaders().value("content-type"));
                            RequestBody body = RequestBody.create((MediaType)mediaType, (File)wrapperObj.getFileWrapper().getFile());
                            Headers fileWrapperHeaders = new Headers(wrapperObj.getHeaders());
                            fileWrapperHeaders.remove("content-type");
                            Headers.Builder fileWrapperHeadersBuilder = OkClient.createRequestHeaders(fileWrapperHeaders);
                            fileWrapperHeadersBuilder.add("Content-Disposition", "form-data; name=" + OkClient.appendQuotedStringAndEncodeEscapeCharacters(param.getKey()) + "; filename=" + OkClient.appendQuotedStringAndEncodeEscapeCharacters(wrapperObj.getFileWrapper().getFile().getName()));
                            multipartBuilder.addPart(fileWrapperHeadersBuilder.build(), body);
                            continue;
                        }
                        if (param.getValue() instanceof MultipartWrapper) {
                            MultipartWrapper wrapperObject = (MultipartWrapper)param.getValue();
                            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)wrapperObject.getHeaders().value("content-type")), (byte[])wrapperObject.getByteArray());
                            Headers wrapperHeaders = new Headers(wrapperObject.getHeaders());
                            wrapperHeaders.remove("content-type");
                            Headers.Builder wrapperHeadersBuilder = OkClient.createRequestHeaders(wrapperHeaders);
                            wrapperHeadersBuilder.add("Content-Disposition", "form-data; name=" + OkClient.appendQuotedStringAndEncodeEscapeCharacters(param.getKey()));
                            multipartBuilder.addPart(wrapperHeadersBuilder.build(), body);
                            continue;
                        }
                        multipartBuilder.addFormDataPart(param.getKey(), param.getValue() == null ? "" : param.getValue().toString());
                    }
                    requestBody = multipartBuilder.build();
                } else {
                    FormBody.Builder formBuilder = new FormBody.Builder();
                    for (AbstractMap.SimpleEntry<String, Object> param : parameters) {
                        formBuilder.add(param.getKey(), param.getValue() == null ? "" : param.getValue().toString());
                    }
                    requestBody = formBuilder.build();
                }
            } else {
                requestBody = httpRequest.getHttpMethod().equals((Object)HttpMethod.GET) ? null : RequestBody.create(null, (byte[])new byte[0]);
            }
        }
        Headers.Builder requestHeaders = new Headers.Builder();
        if (httpRequest.getHeaders() != null) {
            requestHeaders = OkClient.createRequestHeaders(httpRequest.getHeaders());
        }
        StringBuilder urlBuilder = new StringBuilder(httpRequest.getQueryUrl());
        ApiHelper.appendUrlWithQueryParameters(urlBuilder, httpRequest.getQueryParameters());
        String url = ApiHelper.cleanUrl(urlBuilder);
        Request request = new Request.Builder().method(httpRequest.getHttpMethod().toString(), requestBody).headers(requestHeaders.build()).url(url).build();
        return request;
    }

    private static Headers.Builder createRequestHeaders(Headers headers) {
        Headers.Builder requestHeaders = new Headers.Builder();
        for (Map.Entry<String, List<String>> kv : headers.asMultimap().entrySet()) {
            for (String value : kv.getValue()) {
                requestHeaders.add(kv.getKey(), value);
            }
        }
        return requestHeaders;
    }

    private static String appendQuotedStringAndEncodeEscapeCharacters(String key) {
        String target = "\"";
        int len = key.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            switch (ch) {
                case '\n': {
                    target = target + "%0A";
                    continue block5;
                }
                case '\r': {
                    target = target + "%0D";
                    continue block5;
                }
                case '\"': {
                    target = target + "%22";
                    continue block5;
                }
                default: {
                    target = target + ch;
                }
            }
        }
        target = target + '\"';
        return target;
    }

    @Override
    public HttpRequest get(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.GET, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpRequest head(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.HEAD, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpRequest post(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.POST, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpBodyRequest postBody(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, Object body) {
        return new HttpBodyRequest(HttpMethod.POST, queryUrlBuilder, headers, queryParams, body);
    }

    @Override
    public HttpRequest put(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.PUT, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpBodyRequest putBody(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, Object body) {
        return new HttpBodyRequest(HttpMethod.PUT, queryUrlBuilder, headers, queryParams, body);
    }

    @Override
    public HttpRequest patch(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.PATCH, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpBodyRequest patchBody(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, Object body) {
        return new HttpBodyRequest(HttpMethod.PATCH, queryUrlBuilder, headers, queryParams, body);
    }

    @Override
    public HttpRequest delete(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        return new HttpRequest(HttpMethod.DELETE, queryUrlBuilder, headers, queryParams, parameters);
    }

    @Override
    public HttpBodyRequest deleteBody(StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParams, Object body) {
        return new HttpBodyRequest(HttpMethod.DELETE, queryUrlBuilder, headers, queryParams, body);
    }
}

