/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.messaging.controllers;

import com.bandwidth.ApiHelper;
import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.Server;
import com.bandwidth.controllers.BaseController;
import com.bandwidth.exceptions.ApiException;
import com.bandwidth.http.Headers;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpContext;
import com.bandwidth.http.request.HttpBodyRequest;
import com.bandwidth.http.request.HttpRequest;
import com.bandwidth.http.response.ApiResponse;
import com.bandwidth.http.response.HttpResponse;
import com.bandwidth.http.response.HttpStringResponse;
import com.bandwidth.messaging.exceptions.MessagingException;
import com.bandwidth.messaging.models.BandwidthMessage;
import com.bandwidth.messaging.models.Media;
import com.bandwidth.messaging.models.MessageRequest;
import com.bandwidth.utilities.FileWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class APIController
extends BaseController {
    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public ApiResponse<List<Media>> listMedia(String userId, String continuationToken) throws ApiException, IOException {
        HttpRequest request = this.buildListMediaRequest(userId, continuationToken);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleListMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<List<Media>>> listMediaAsync(String userId, String continuationToken) {
        return this.makeHttpCallAsync(() -> this.buildListMediaRequest(userId, continuationToken), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleListMediaResponse(context));
    }

    private HttpRequest buildListMediaRequest(String userId, String continuationToken) {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{userId}/media");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("userId", new AbstractMap.SimpleEntry<String, Boolean>(userId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Continuation-Token", continuationToken);
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<List<Media>> handleListMediaResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, Media[].class);
        return new ApiResponse<List<Media>>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<InputStream> getMedia(String userId, String mediaId) throws ApiException, IOException {
        HttpRequest request = this.buildGetMediaRequest(userId, mediaId);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsBinary(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<InputStream>> getMediaAsync(String userId, String mediaId) {
        return this.makeHttpCallAsync(() -> this.buildGetMediaRequest(userId, mediaId), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetMediaResponse(context));
    }

    private HttpRequest buildGetMediaRequest(String userId, String mediaId) {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{userId}/media/{mediaId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("userId", new AbstractMap.SimpleEntry<String, Boolean>(userId, true));
        templateParameters.put("mediaId", new AbstractMap.SimpleEntry<String, Boolean>(mediaId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<InputStream> handleGetMediaResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        InputStream result = response.getRawBody();
        return new ApiResponse<InputStream>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> uploadMedia(String userId, String mediaId, long contentLength, FileWrapper body, String contentType, String cacheControl) throws ApiException, IOException {
        HttpRequest request = this.buildUploadMediaRequest(userId, mediaId, contentLength, body, contentType, cacheControl);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleUploadMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> uploadMediaAsync(String userId, String mediaId, long contentLength, FileWrapper body, String contentType, String cacheControl) {
        return this.makeHttpCallAsync(() -> this.buildUploadMediaRequest(userId, mediaId, contentLength, body, contentType, cacheControl), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleUploadMediaResponse(context));
    }

    private HttpRequest buildUploadMediaRequest(String userId, String mediaId, long contentLength, FileWrapper body, String contentType, String cacheControl) {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{userId}/media/{mediaId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("userId", new AbstractMap.SimpleEntry<String, Boolean>(userId, true));
        templateParameters.put("mediaId", new AbstractMap.SimpleEntry<String, Boolean>(mediaId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Length", String.valueOf(contentLength));
        headers.add("Content-Type", contentType != null ? contentType : "application/octet-stream");
        headers.add("Cache-Control", cacheControl);
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, body);
        return request;
    }

    private ApiResponse<Void> handleUploadMediaResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Void> deleteMedia(String userId, String mediaId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteMediaRequest(userId, mediaId);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteMediaAsync(String userId, String mediaId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteMediaRequest(userId, mediaId), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleDeleteMediaResponse(context));
    }

    private HttpRequest buildDeleteMediaRequest(String userId, String mediaId) {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{userId}/media/{mediaId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("userId", new AbstractMap.SimpleEntry<String, Boolean>(userId, true));
        templateParameters.put("mediaId", new AbstractMap.SimpleEntry<String, Boolean>(mediaId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<Void> handleDeleteMediaResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<BandwidthMessage> createMessage(String userId, MessageRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateMessageRequest(userId, body);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateMessageResponse(context);
    }

    public CompletableFuture<ApiResponse<BandwidthMessage>> createMessageAsync(String userId, MessageRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateMessageRequest(userId, body), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleCreateMessageResponse(context));
    }

    private HttpRequest buildCreateMessageRequest(String userId, MessageRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{userId}/messages");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("userId", new AbstractMap.SimpleEntry<String, Boolean>(userId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        return request;
    }

    private ApiResponse<BandwidthMessage> handleCreateMessageResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BandwidthMessage result = ApiHelper.deserialize(responseBody, BandwidthMessage.class);
        return new ApiResponse<BandwidthMessage>(response.getStatusCode(), response.getHeaders(), result);
    }
}

