/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.messaging.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

public class MessageRequest {
    private String applicationId;
    private List<String> to;
    private String from;
    private String text;
    private List<String> media;
    private String tag;

    public MessageRequest() {
    }

    public MessageRequest(String applicationId, List<String> to, String from, String text, List<String> media, String tag) {
        this.applicationId = applicationId;
        this.to = to;
        this.from = from;
        this.text = text;
        this.media = media;
        this.tag = tag;
    }

    @JsonGetter(value="applicationId")
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonSetter(value="applicationId")
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @JsonGetter(value="to")
    public List<String> getTo() {
        return this.to;
    }

    @JsonSetter(value="to")
    public void setTo(List<String> to) {
        this.to = to;
    }

    @JsonGetter(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonSetter(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    @JsonGetter(value="text")
    public String getText() {
        return this.text;
    }

    @JsonSetter(value="text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonGetter(value="media")
    public List<String> getMedia() {
        return this.media;
    }

    @JsonSetter(value="media")
    public void setMedia(List<String> media) {
        this.media = media;
    }

    @JsonGetter(value="tag")
    public String getTag() {
        return this.tag;
    }

    @JsonSetter(value="tag")
    public void setTag(String tag) {
        this.tag = tag;
    }

    public Builder toBuilder() {
        Builder builder = new Builder().applicationId(this.getApplicationId()).to(this.getTo()).from(this.getFrom()).text(this.getText()).media(this.getMedia()).tag(this.getTag());
        return builder;
    }

    public static class Builder {
        private String applicationId;
        private List<String> to;
        private String from;
        private String text;
        private List<String> media;
        private String tag;

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder to(List<String> to) {
            this.to = to;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder media(List<String> media) {
            this.media = media;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public MessageRequest build() {
            return new MessageRequest(this.applicationId, this.to, this.from, this.text, this.media, this.tag);
        }
    }
}

