/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.twofactorauth.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;

public class TwoFactorCodeRequestSchema {
    private String to;
    private String from;
    private String applicationId;
    private String scope;
    private String message;
    private double digits;

    public TwoFactorCodeRequestSchema() {
    }

    public TwoFactorCodeRequestSchema(String to, String from, String applicationId, String message, double digits, String scope) {
        this.to = to;
        this.from = from;
        this.applicationId = applicationId;
        this.scope = scope;
        this.message = message;
        this.digits = digits;
    }

    @JsonGetter(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonSetter(value="to")
    public void setTo(String to) {
        this.to = to;
    }

    @JsonGetter(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonSetter(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    @JsonGetter(value="applicationId")
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonSetter(value="applicationId")
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @JsonGetter(value="scope")
    public String getScope() {
        return this.scope;
    }

    @JsonSetter(value="scope")
    public void setScope(String scope) {
        this.scope = scope;
    }

    @JsonGetter(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonSetter(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonGetter(value="digits")
    public double getDigits() {
        return this.digits;
    }

    @JsonSetter(value="digits")
    public void setDigits(double digits) {
        this.digits = digits;
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.to, this.from, this.applicationId, this.message, this.digits).scope(this.getScope());
        return builder;
    }

    public static class Builder {
        private String to;
        private String from;
        private String applicationId;
        private String message;
        private double digits;
        private String scope;

        public Builder() {
        }

        public Builder(String to, String from, String applicationId, String message, double digits) {
            this.to = to;
            this.from = from;
            this.applicationId = applicationId;
            this.message = message;
            this.digits = digits;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder digits(double digits) {
            this.digits = digits;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public TwoFactorCodeRequestSchema build() {
            return new TwoFactorCodeRequestSchema(this.to, this.from, this.applicationId, this.message, this.digits, this.scope);
        }
    }
}

