/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.bxml.verbs;

import com.bandwidth.voice.bxml.verbs.Method;
import com.bandwidth.voice.bxml.verbs.Verb;
import java.net.URI;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="Bridge")
public class Bridge
implements Verb {
    public static final String TYPE_NAME = "Bridge";
    @XmlValue
    private String callId;
    @XmlAttribute
    private URI bridgeCompleteFallbackUrl;
    @XmlAttribute
    private Method bridgeCompleteFallbackMethod;
    @XmlAttribute
    private URI bridgeTargetCompleteFallbackUrl;
    @XmlAttribute
    private Method bridgeTargetCompleteFallbackMethod;
    @XmlAttribute
    private String fallbackUsername;
    @XmlAttribute
    private String fallbackPassword;
    @XmlAttribute
    private URI bridgeCompleteUrl;
    @XmlAttribute
    private Method bridgeCompleteMethod;
    @XmlAttribute
    private URI bridgeTargetCompleteUrl;
    @XmlAttribute
    private Method bridgeTargetCompleteMethod;
    @XmlAttribute
    protected String username;
    @XmlAttribute
    protected String password;
    @XmlAttribute
    private String tag;

    Bridge(String callId, URI bridgeCompleteFallbackUrl, Method bridgeCompleteFallbackMethod, URI bridgeTargetCompleteFallbackUrl, Method bridgeTargetCompleteFallbackMethod, String fallbackUsername, String fallbackPassword, URI bridgeCompleteUrl, Method bridgeCompleteMethod, URI bridgeTargetCompleteUrl, Method bridgeTargetCompleteMethod, String username, String password, String tag) {
        this.callId = callId;
        this.bridgeCompleteFallbackUrl = bridgeCompleteFallbackUrl;
        this.bridgeCompleteFallbackMethod = bridgeCompleteFallbackMethod;
        this.bridgeTargetCompleteFallbackUrl = bridgeTargetCompleteFallbackUrl;
        this.bridgeTargetCompleteFallbackMethod = bridgeTargetCompleteFallbackMethod;
        this.fallbackUsername = fallbackUsername;
        this.fallbackPassword = fallbackPassword;
        this.bridgeCompleteUrl = bridgeCompleteUrl;
        this.bridgeCompleteMethod = bridgeCompleteMethod;
        this.bridgeTargetCompleteUrl = bridgeTargetCompleteUrl;
        this.bridgeTargetCompleteMethod = bridgeTargetCompleteMethod;
        this.username = username;
        this.password = password;
        this.tag = tag;
    }

    public static BridgeBuilder builder() {
        return new BridgeBuilder();
    }

    public static class BridgeBuilder {
        private String callId;
        private URI bridgeCompleteFallbackUrl;
        private Method bridgeCompleteFallbackMethod;
        private URI bridgeTargetCompleteFallbackUrl;
        private Method bridgeTargetCompleteFallbackMethod;
        private String fallbackUsername;
        private String fallbackPassword;
        private URI bridgeCompleteUrl;
        private Method bridgeCompleteMethod;
        private URI bridgeTargetCompleteUrl;
        private Method bridgeTargetCompleteMethod;
        private String username;
        private String password;
        private String tag;

        public BridgeBuilder bridgeCompleteUrl(String url) {
            return this.bridgeCompleteUrl(URI.create(url));
        }

        public BridgeBuilder bridgeCompleteUrl(URI url) {
            this.bridgeCompleteUrl = url;
            return this;
        }

        public BridgeBuilder bridgeCompleteFallbackUrl(String url) {
            return this.bridgeCompleteFallbackUrl(URI.create(url));
        }

        public BridgeBuilder bridgeCompleteFallbackUrl(URI url) {
            this.bridgeCompleteFallbackUrl = url;
            return this;
        }

        public BridgeBuilder bridgeCompleteFallbackMethod(String method) {
            return this.bridgeCompleteFallbackMethod(Method.fromValue(method));
        }

        public BridgeBuilder bridgeCompleteFallbackMethod(Method method) {
            this.bridgeCompleteFallbackMethod = method;
            return this;
        }

        public BridgeBuilder bridgeTargetCompleteFallbackUrl(String url) {
            return this.bridgeTargetCompleteFallbackUrl(URI.create(url));
        }

        public BridgeBuilder bridgeTargetCompleteFallbackUrl(URI url) {
            this.bridgeTargetCompleteFallbackUrl = url;
            return this;
        }

        public BridgeBuilder bridgeTargetCompleteFallbackMethod(String method) {
            return this.bridgeTargetCompleteFallbackMethod(Method.fromValue(method));
        }

        public BridgeBuilder bridgeTargetCompleteFallbackMethod(Method method) {
            this.bridgeTargetCompleteFallbackMethod = method;
            return this;
        }

        public BridgeBuilder bridgeCompleteMethod(String method) {
            return this.bridgeCompleteMethod(Method.fromValue(method));
        }

        public BridgeBuilder bridgeCompleteMethod(Method method) {
            this.bridgeCompleteMethod = method;
            return this;
        }

        public BridgeBuilder bridgeTargetCompleteUrl(String url) {
            return this.bridgeTargetCompleteUrl(URI.create(url));
        }

        public BridgeBuilder bridgeTargetCompleteUrl(URI url) {
            this.bridgeTargetCompleteUrl = url;
            return this;
        }

        public BridgeBuilder bridgeTargetCompleteMethod(String method) {
            return this.bridgeTargetCompleteMethod(Method.fromValue(method));
        }

        public BridgeBuilder bridgeTargetCompleteMethod(Method method) {
            this.bridgeTargetCompleteMethod = method;
            return this;
        }

        BridgeBuilder() {
        }

        public BridgeBuilder callId(String callId) {
            this.callId = callId;
            return this;
        }

        public BridgeBuilder fallbackUsername(String fallbackUsername) {
            this.fallbackUsername = fallbackUsername;
            return this;
        }

        public BridgeBuilder fallbackPassword(String fallbackPassword) {
            this.fallbackPassword = fallbackPassword;
            return this;
        }

        public BridgeBuilder username(String username) {
            this.username = username;
            return this;
        }

        public BridgeBuilder password(String password) {
            this.password = password;
            return this;
        }

        public BridgeBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Bridge build() {
            return new Bridge(this.callId, this.bridgeCompleteFallbackUrl, this.bridgeCompleteFallbackMethod, this.bridgeTargetCompleteFallbackUrl, this.bridgeTargetCompleteFallbackMethod, this.fallbackUsername, this.fallbackPassword, this.bridgeCompleteUrl, this.bridgeCompleteMethod, this.bridgeTargetCompleteUrl, this.bridgeTargetCompleteMethod, this.username, this.password, this.tag);
        }

        public String toString() {
            return "Bridge.BridgeBuilder(callId=" + this.callId + ", bridgeCompleteFallbackUrl=" + this.bridgeCompleteFallbackUrl + ", bridgeCompleteFallbackMethod=" + (Object)((Object)this.bridgeCompleteFallbackMethod) + ", bridgeTargetCompleteFallbackUrl=" + this.bridgeTargetCompleteFallbackUrl + ", bridgeTargetCompleteFallbackMethod=" + (Object)((Object)this.bridgeTargetCompleteFallbackMethod) + ", fallbackUsername=" + this.fallbackUsername + ", fallbackPassword=" + this.fallbackPassword + ", bridgeCompleteUrl=" + this.bridgeCompleteUrl + ", bridgeCompleteMethod=" + (Object)((Object)this.bridgeCompleteMethod) + ", bridgeTargetCompleteUrl=" + this.bridgeTargetCompleteUrl + ", bridgeTargetCompleteMethod=" + (Object)((Object)this.bridgeTargetCompleteMethod) + ", username=" + this.username + ", password=" + this.password + ", tag=" + this.tag + ")";
        }
    }
}

