/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.bxml.verbs;

import com.bandwidth.voice.bxml.verbs.Method;
import java.net.URI;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="PhoneNumber")
public class PhoneNumber {
    public static final String TYPE_NAME = "PhoneNumber";
    @XmlValue
    private String phoneNumber;
    @XmlAttribute
    private URI transferAnswerUrl;
    @XmlAttribute
    private Method transferAnswerMethod;
    @XmlAttribute
    private URI transferDisconnectUrl;
    @XmlAttribute
    private Method transferDisconnectMethod;
    @XmlAttribute
    protected String username;
    @XmlAttribute
    protected String password;
    @XmlAttribute
    private String tag;
    @XmlAttribute
    protected String fallbackUsername;
    @XmlAttribute
    protected String fallbackPassword;
    @XmlAttribute
    protected URI transferAnswerFallbackUrl;
    @XmlAttribute
    protected Method transferAnswerFallbackMethod;

    PhoneNumber(String phoneNumber, URI transferAnswerUrl, Method transferAnswerMethod, URI transferDisconnectUrl, Method transferDisconnectMethod, String username, String password, String tag, String fallbackUsername, String fallbackPassword, URI transferAnswerFallbackUrl, Method transferAnswerFallbackMethod) {
        this.phoneNumber = phoneNumber;
        this.transferAnswerUrl = transferAnswerUrl;
        this.transferAnswerMethod = transferAnswerMethod;
        this.transferDisconnectUrl = transferDisconnectUrl;
        this.transferDisconnectMethod = transferDisconnectMethod;
        this.username = username;
        this.password = password;
        this.tag = tag;
        this.fallbackUsername = fallbackUsername;
        this.fallbackPassword = fallbackPassword;
        this.transferAnswerFallbackUrl = transferAnswerFallbackUrl;
        this.transferAnswerFallbackMethod = transferAnswerFallbackMethod;
    }

    public static PhoneNumberBuilder builder() {
        return new PhoneNumberBuilder();
    }

    public static class PhoneNumberBuilder {
        private String phoneNumber;
        private URI transferAnswerUrl;
        private Method transferAnswerMethod;
        private URI transferDisconnectUrl;
        private Method transferDisconnectMethod;
        private String username;
        private String password;
        private String tag;
        private String fallbackUsername;
        private String fallbackPassword;
        private URI transferAnswerFallbackUrl;
        private Method transferAnswerFallbackMethod;

        public PhoneNumberBuilder transferAnswerUrl(String uri) {
            return this.transferAnswerUrl(URI.create(uri));
        }

        public PhoneNumberBuilder transferAnswerUrl(URI uri) {
            this.transferAnswerUrl = uri;
            return this;
        }

        public PhoneNumberBuilder transferAnswerFallbackUrl(String uri) {
            return this.transferAnswerFallbackUrl(URI.create(uri));
        }

        public PhoneNumberBuilder transferAnswerFallbackUrl(URI uri) {
            this.transferAnswerFallbackUrl = uri;
            return this;
        }

        public PhoneNumberBuilder transferAnswerFallbackMethod(String method) {
            return this.transferAnswerFallbackMethod(Method.fromValue(method));
        }

        public PhoneNumberBuilder transferAnswerFallbackMethod(Method method) {
            this.transferAnswerFallbackMethod = method;
            return this;
        }

        public PhoneNumberBuilder transferDisconnectUrl(String uri) {
            return this.transferDisconnectUrl(URI.create(uri));
        }

        public PhoneNumberBuilder transferDisconnectUrl(URI uri) {
            this.transferDisconnectUrl = uri;
            return this;
        }

        public PhoneNumberBuilder transferAnswerMethod(String method) {
            return this.transferAnswerMethod(Method.fromValue(method));
        }

        public PhoneNumberBuilder transferAnswerMethod(Method method) {
            this.transferAnswerMethod = method;
            return this;
        }

        public PhoneNumberBuilder transferDisconnectMethod(String method) {
            return this.transferDisconnectMethod(Method.fromValue(method));
        }

        public PhoneNumberBuilder transferDisconnectMethod(Method method) {
            this.transferDisconnectMethod = method;
            return this;
        }

        PhoneNumberBuilder() {
        }

        public PhoneNumberBuilder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public PhoneNumberBuilder username(String username) {
            this.username = username;
            return this;
        }

        public PhoneNumberBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PhoneNumberBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public PhoneNumberBuilder fallbackUsername(String fallbackUsername) {
            this.fallbackUsername = fallbackUsername;
            return this;
        }

        public PhoneNumberBuilder fallbackPassword(String fallbackPassword) {
            this.fallbackPassword = fallbackPassword;
            return this;
        }

        public PhoneNumber build() {
            return new PhoneNumber(this.phoneNumber, this.transferAnswerUrl, this.transferAnswerMethod, this.transferDisconnectUrl, this.transferDisconnectMethod, this.username, this.password, this.tag, this.fallbackUsername, this.fallbackPassword, this.transferAnswerFallbackUrl, this.transferAnswerFallbackMethod);
        }

        public String toString() {
            return "PhoneNumber.PhoneNumberBuilder(phoneNumber=" + this.phoneNumber + ", transferAnswerUrl=" + this.transferAnswerUrl + ", transferAnswerMethod=" + (Object)((Object)this.transferAnswerMethod) + ", transferDisconnectUrl=" + this.transferDisconnectUrl + ", transferDisconnectMethod=" + (Object)((Object)this.transferDisconnectMethod) + ", username=" + this.username + ", password=" + this.password + ", tag=" + this.tag + ", fallbackUsername=" + this.fallbackUsername + ", fallbackPassword=" + this.fallbackPassword + ", transferAnswerFallbackUrl=" + this.transferAnswerFallbackUrl + ", transferAnswerFallbackMethod=" + (Object)((Object)this.transferAnswerFallbackMethod) + ")";
        }
    }
}

