/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.bxml.verbs;

import com.bandwidth.voice.bxml.verbs.AudioProducer;
import com.bandwidth.voice.bxml.verbs.Verb;
import java.net.URI;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="PlayAudio")
public class PlayAudio
implements Verb,
AudioProducer {
    public static final String TYPE_NAME = "PlayAudio";
    @XmlValue
    private URI audioUri;
    @XmlAttribute
    protected String username;
    @XmlAttribute
    protected String password;

    PlayAudio(URI audioUri, String username, String password) {
        this.audioUri = audioUri;
        this.username = username;
        this.password = password;
    }

    public static PlayAudioBuilder builder() {
        return new PlayAudioBuilder();
    }

    public static class PlayAudioBuilder {
        private URI audioUri;
        private String username;
        private String password;

        public PlayAudioBuilder audioUri(String uri) {
            return this.audioUri(URI.create(uri));
        }

        public PlayAudioBuilder audioUri(URI uri) {
            this.audioUri = uri;
            return this;
        }

        PlayAudioBuilder() {
        }

        public PlayAudioBuilder username(String username) {
            this.username = username;
            return this;
        }

        public PlayAudioBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PlayAudio build() {
            return new PlayAudio(this.audioUri, this.username, this.password);
        }

        public String toString() {
            return "PlayAudio.PlayAudioBuilder(audioUri=" + this.audioUri + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

