/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.bxml.verbs;

import com.bandwidth.voice.bxml.verbs.Method;
import com.bandwidth.voice.bxml.verbs.Verb;
import java.net.URI;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Record")
public class Record
implements Verb {
    public static final String TYPE_NAME = "Record";
    @XmlAttribute
    private boolean transcribe;
    @XmlAttribute
    private Integer silenceTimeout;
    @XmlAttribute
    private URI transcriptionAvailableUrl;
    @XmlAttribute
    private Method transcriptionAvailableMethod;
    @XmlAttribute
    private URI recordCompleteUrl;
    @XmlAttribute
    private Method recordCompleteMethod;
    @XmlAttribute
    private URI recordingAvailableUrl;
    @XmlAttribute
    private Method recordingAvailableMethod;
    @XmlAttribute
    private String tag;
    @XmlAttribute
    protected String username;
    @XmlAttribute
    protected String password;
    @XmlAttribute
    protected String terminatingDigits;
    @XmlAttribute
    protected Integer maxDuration;
    @XmlAttribute
    protected String fileFormat;
    @XmlAttribute
    protected String fallbackUsername;
    @XmlAttribute
    protected String fallbackPassword;
    @XmlAttribute
    protected URI recordCompleteFallbackUrl;
    @XmlAttribute
    protected Method recordCompleteFallbackMethod;

    Record(boolean transcribe, Integer silenceTimeout, URI transcriptionAvailableUrl, Method transcriptionAvailableMethod, URI recordCompleteUrl, Method recordCompleteMethod, URI recordingAvailableUrl, Method recordingAvailableMethod, String tag, String username, String password, String terminatingDigits, Integer maxDuration, String fileFormat, String fallbackUsername, String fallbackPassword, URI recordCompleteFallbackUrl, Method recordCompleteFallbackMethod) {
        this.transcribe = transcribe;
        this.silenceTimeout = silenceTimeout;
        this.transcriptionAvailableUrl = transcriptionAvailableUrl;
        this.transcriptionAvailableMethod = transcriptionAvailableMethod;
        this.recordCompleteUrl = recordCompleteUrl;
        this.recordCompleteMethod = recordCompleteMethod;
        this.recordingAvailableUrl = recordingAvailableUrl;
        this.recordingAvailableMethod = recordingAvailableMethod;
        this.tag = tag;
        this.username = username;
        this.password = password;
        this.terminatingDigits = terminatingDigits;
        this.maxDuration = maxDuration;
        this.fileFormat = fileFormat;
        this.fallbackUsername = fallbackUsername;
        this.fallbackPassword = fallbackPassword;
        this.recordCompleteFallbackUrl = recordCompleteFallbackUrl;
        this.recordCompleteFallbackMethod = recordCompleteFallbackMethod;
    }

    public static RecordBuilder builder() {
        return new RecordBuilder();
    }

    public static class RecordBuilder {
        private boolean transcribe;
        private Integer silenceTimeout;
        private URI transcriptionAvailableUrl;
        private Method transcriptionAvailableMethod;
        private URI recordCompleteUrl;
        private Method recordCompleteMethod;
        private URI recordingAvailableUrl;
        private Method recordingAvailableMethod;
        private String tag;
        private String username;
        private String password;
        private String terminatingDigits;
        private Integer maxDuration;
        private String fileFormat;
        private String fallbackUsername;
        private String fallbackPassword;
        private URI recordCompleteFallbackUrl;
        private Method recordCompleteFallbackMethod;

        public RecordBuilder transcriptionAvailableUrl(URI uri) {
            this.transcriptionAvailableUrl = uri;
            return this;
        }

        public RecordBuilder transcriptionAvailableUrl(String uri) {
            return this.transcriptionAvailableUrl(URI.create(uri));
        }

        public RecordBuilder recordCompleteFallbackUrl(URI uri) {
            this.recordCompleteFallbackUrl = uri;
            return this;
        }

        public RecordBuilder recordCompleteFallbackUrl(String uri) {
            return this.recordCompleteFallbackUrl(URI.create(uri));
        }

        public RecordBuilder transcriptionAvailableMethod(Method method) {
            this.transcriptionAvailableMethod = method;
            return this;
        }

        public RecordBuilder transcriptionAvailableMethod(String method) {
            return this.transcriptionAvailableMethod(Method.fromValue(method));
        }

        public RecordBuilder recordCompleteFallbackMethod(Method method) {
            this.recordCompleteFallbackMethod = method;
            return this;
        }

        public RecordBuilder recordCompleteFallbackMethod(String method) {
            return this.recordCompleteFallbackMethod(Method.fromValue(method));
        }

        public RecordBuilder recordCompleteUrl(URI uri) {
            this.recordCompleteUrl = uri;
            return this;
        }

        public RecordBuilder recordCompleteUrl(String uri) {
            return this.recordCompleteUrl(URI.create(uri));
        }

        public RecordBuilder recordCompleteMethod(Method method) {
            this.recordCompleteMethod = method;
            return this;
        }

        public RecordBuilder recordCompleteMethod(String method) {
            return this.recordCompleteMethod(Method.fromValue(method));
        }

        public RecordBuilder recordingAvailableUrl(URI uri) {
            this.recordingAvailableUrl = uri;
            return this;
        }

        public RecordBuilder recordingAvailableUrl(String uri) {
            return this.recordingAvailableUrl(URI.create(uri));
        }

        public RecordBuilder recordingAvailableMethod(Method method) {
            this.recordingAvailableMethod = method;
            return this;
        }

        public RecordBuilder recordingAvailableMethod(String method) {
            return this.recordingAvailableMethod(Method.fromValue(method));
        }

        RecordBuilder() {
        }

        public RecordBuilder transcribe(boolean transcribe) {
            this.transcribe = transcribe;
            return this;
        }

        public RecordBuilder silenceTimeout(Integer silenceTimeout) {
            this.silenceTimeout = silenceTimeout;
            return this;
        }

        public RecordBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public RecordBuilder username(String username) {
            this.username = username;
            return this;
        }

        public RecordBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RecordBuilder terminatingDigits(String terminatingDigits) {
            this.terminatingDigits = terminatingDigits;
            return this;
        }

        public RecordBuilder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public RecordBuilder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public RecordBuilder fallbackUsername(String fallbackUsername) {
            this.fallbackUsername = fallbackUsername;
            return this;
        }

        public RecordBuilder fallbackPassword(String fallbackPassword) {
            this.fallbackPassword = fallbackPassword;
            return this;
        }

        public Record build() {
            return new Record(this.transcribe, this.silenceTimeout, this.transcriptionAvailableUrl, this.transcriptionAvailableMethod, this.recordCompleteUrl, this.recordCompleteMethod, this.recordingAvailableUrl, this.recordingAvailableMethod, this.tag, this.username, this.password, this.terminatingDigits, this.maxDuration, this.fileFormat, this.fallbackUsername, this.fallbackPassword, this.recordCompleteFallbackUrl, this.recordCompleteFallbackMethod);
        }

        public String toString() {
            return "Record.RecordBuilder(transcribe=" + this.transcribe + ", silenceTimeout=" + this.silenceTimeout + ", transcriptionAvailableUrl=" + this.transcriptionAvailableUrl + ", transcriptionAvailableMethod=" + (Object)((Object)this.transcriptionAvailableMethod) + ", recordCompleteUrl=" + this.recordCompleteUrl + ", recordCompleteMethod=" + (Object)((Object)this.recordCompleteMethod) + ", recordingAvailableUrl=" + this.recordingAvailableUrl + ", recordingAvailableMethod=" + (Object)((Object)this.recordingAvailableMethod) + ", tag=" + this.tag + ", username=" + this.username + ", password=" + this.password + ", terminatingDigits=" + this.terminatingDigits + ", maxDuration=" + this.maxDuration + ", fileFormat=" + this.fileFormat + ", fallbackUsername=" + this.fallbackUsername + ", fallbackPassword=" + this.fallbackPassword + ", recordCompleteFallbackUrl=" + this.recordCompleteFallbackUrl + ", recordCompleteFallbackMethod=" + (Object)((Object)this.recordCompleteFallbackMethod) + ")";
        }
    }
}

