/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.bxml.verbs;

import com.bandwidth.voice.bxml.verbs.Method;
import com.bandwidth.voice.bxml.verbs.PhoneNumber;
import com.bandwidth.voice.bxml.verbs.Verb;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="Transfer")
public class Transfer
implements Verb {
    public static final String TYPE_NAME = "Transfer";
    @XmlElement(name="PhoneNumber")
    private final List<PhoneNumber> phoneNumbers;
    @XmlAttribute
    private String transferCallerId;
    @XmlAttribute
    private Double callTimeout;
    @XmlAttribute
    private URI transferCompleteUrl;
    @XmlAttribute
    private Method transferCompleteMethod;
    @XmlAttribute
    protected String username;
    @XmlAttribute
    protected String password;
    @XmlAttribute
    private String tag;
    @XmlAttribute
    private String diversionTreatment;
    @XmlAttribute
    private String diversionReason;
    @XmlAttribute
    protected String fallbackUsername;
    @XmlAttribute
    protected String fallbackPassword;
    @XmlAttribute
    protected URI transferCompleteFallbackUrl;
    @XmlAttribute
    protected Method transferCompleteFallbackMethod;

    Transfer(List<PhoneNumber> phoneNumbers, String transferCallerId, Double callTimeout, URI transferCompleteUrl, Method transferCompleteMethod, String username, String password, String tag, String diversionTreatment, String diversionReason, String fallbackUsername, String fallbackPassword, URI transferCompleteFallbackUrl, Method transferCompleteFallbackMethod) {
        this.phoneNumbers = phoneNumbers;
        this.transferCallerId = transferCallerId;
        this.callTimeout = callTimeout;
        this.transferCompleteUrl = transferCompleteUrl;
        this.transferCompleteMethod = transferCompleteMethod;
        this.username = username;
        this.password = password;
        this.tag = tag;
        this.diversionTreatment = diversionTreatment;
        this.diversionReason = diversionReason;
        this.fallbackUsername = fallbackUsername;
        this.fallbackPassword = fallbackPassword;
        this.transferCompleteFallbackUrl = transferCompleteFallbackUrl;
        this.transferCompleteFallbackMethod = transferCompleteFallbackMethod;
    }

    public static TransferBuilder builder() {
        return new TransferBuilder();
    }

    public static class TransferBuilder {
        private List<PhoneNumber> phoneNumbers;
        private String transferCallerId;
        private Double callTimeout;
        private URI transferCompleteUrl;
        private Method transferCompleteMethod;
        private String username;
        private String password;
        private String tag;
        private String diversionTreatment;
        private String diversionReason;
        private String fallbackUsername;
        private String fallbackPassword;
        private URI transferCompleteFallbackUrl;
        private Method transferCompleteFallbackMethod;

        public TransferBuilder transferCompleteUrl(URI uri) {
            this.transferCompleteUrl = uri;
            return this;
        }

        public TransferBuilder transferCompleteUrl(String uri) {
            return this.transferCompleteUrl(URI.create(uri));
        }

        public TransferBuilder transferCompleteFallbackUrl(URI uri) {
            this.transferCompleteFallbackUrl = uri;
            return this;
        }

        public TransferBuilder transferCompleteFallbackUrl(String uri) {
            return this.transferCompleteFallbackUrl(URI.create(uri));
        }

        public TransferBuilder transferCompleteMethod(Method method) {
            this.transferCompleteMethod = method;
            return this;
        }

        public TransferBuilder transferCompleteMethod(String method) {
            return this.transferCompleteMethod(Method.fromValue(method));
        }

        public TransferBuilder transferCompleteFallbackMethod(Method method) {
            this.transferCompleteFallbackMethod = method;
            return this;
        }

        public TransferBuilder transferCompleteFallbackMethod(String method) {
            return this.transferCompleteFallbackMethod(Method.fromValue(method));
        }

        public TransferBuilder phoneNumbers(PhoneNumber ... phoneNumbers) {
            this.phoneNumbers = Arrays.asList(phoneNumbers);
            return this;
        }

        public TransferBuilder phoneNumbers(List<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        TransferBuilder() {
        }

        public TransferBuilder transferCallerId(String transferCallerId) {
            this.transferCallerId = transferCallerId;
            return this;
        }

        public TransferBuilder callTimeout(Double callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public TransferBuilder username(String username) {
            this.username = username;
            return this;
        }

        public TransferBuilder password(String password) {
            this.password = password;
            return this;
        }

        public TransferBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public TransferBuilder diversionTreatment(String diversionTreatment) {
            this.diversionTreatment = diversionTreatment;
            return this;
        }

        public TransferBuilder diversionReason(String diversionReason) {
            this.diversionReason = diversionReason;
            return this;
        }

        public TransferBuilder fallbackUsername(String fallbackUsername) {
            this.fallbackUsername = fallbackUsername;
            return this;
        }

        public TransferBuilder fallbackPassword(String fallbackPassword) {
            this.fallbackPassword = fallbackPassword;
            return this;
        }

        public Transfer build() {
            return new Transfer(this.phoneNumbers, this.transferCallerId, this.callTimeout, this.transferCompleteUrl, this.transferCompleteMethod, this.username, this.password, this.tag, this.diversionTreatment, this.diversionReason, this.fallbackUsername, this.fallbackPassword, this.transferCompleteFallbackUrl, this.transferCompleteFallbackMethod);
        }

        public String toString() {
            return "Transfer.TransferBuilder(phoneNumbers=" + this.phoneNumbers + ", transferCallerId=" + this.transferCallerId + ", callTimeout=" + this.callTimeout + ", transferCompleteUrl=" + this.transferCompleteUrl + ", transferCompleteMethod=" + (Object)((Object)this.transferCompleteMethod) + ", username=" + this.username + ", password=" + this.password + ", tag=" + this.tag + ", diversionTreatment=" + this.diversionTreatment + ", diversionReason=" + this.diversionReason + ", fallbackUsername=" + this.fallbackUsername + ", fallbackPassword=" + this.fallbackPassword + ", transferCompleteFallbackUrl=" + this.transferCompleteFallbackUrl + ", transferCompleteFallbackMethod=" + (Object)((Object)this.transferCompleteFallbackMethod) + ")";
        }
    }
}

