/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.controllers;

import com.bandwidth.ApiHelper;
import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.Server;
import com.bandwidth.controllers.BaseController;
import com.bandwidth.exceptions.ApiException;
import com.bandwidth.http.Headers;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpContext;
import com.bandwidth.http.request.HttpBodyRequest;
import com.bandwidth.http.request.HttpRequest;
import com.bandwidth.http.response.ApiResponse;
import com.bandwidth.http.response.HttpResponse;
import com.bandwidth.http.response.HttpStringResponse;
import com.bandwidth.voice.exceptions.ApiErrorResponseException;
import com.bandwidth.voice.models.ApiCallResponse;
import com.bandwidth.voice.models.ApiCallStateResponse;
import com.bandwidth.voice.models.ApiCreateCallRequest;
import com.bandwidth.voice.models.ApiModifyCallRequest;
import com.bandwidth.voice.models.ApiTranscribeRecordingRequest;
import com.bandwidth.voice.models.CallEngineModifyConferenceRequest;
import com.bandwidth.voice.models.ConferenceDetail;
import com.bandwidth.voice.models.ConferenceMemberDetail;
import com.bandwidth.voice.models.ConferenceRecordingMetadataResponse;
import com.bandwidth.voice.models.ModifyCallRecordingState;
import com.bandwidth.voice.models.RecordingMetadataResponse;
import com.bandwidth.voice.models.TranscriptionResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class APIController
extends BaseController {
    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public ApiResponse<ApiCallResponse> createCall(String accountId, ApiCreateCallRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateCallRequest(accountId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateCallResponse(context);
    }

    public CompletableFuture<ApiResponse<ApiCallResponse>> createCallAsync(String accountId, ApiCreateCallRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateCallRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleCreateCallResponse(context));
    }

    private HttpRequest buildCreateCallRequest(String accountId, ApiCreateCallRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        return request;
    }

    private ApiResponse<ApiCallResponse> handleCreateCallResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ApiCallResponse result = ApiHelper.deserialize(responseBody, ApiCallResponse.class);
        return new ApiResponse<ApiCallResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<ApiCallStateResponse> getCallState(String accountId, String callId) throws ApiException, IOException {
        HttpRequest request = this.buildGetCallStateRequest(accountId, callId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetCallStateResponse(context);
    }

    public CompletableFuture<ApiResponse<ApiCallStateResponse>> getCallStateAsync(String accountId, String callId) {
        return this.makeHttpCallAsync(() -> this.buildGetCallStateRequest(accountId, callId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetCallStateResponse(context));
    }

    private HttpRequest buildGetCallStateRequest(String accountId, String callId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<ApiCallStateResponse> handleGetCallStateResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ApiCallStateResponse result = ApiHelper.deserialize(responseBody, ApiCallStateResponse.class);
        return new ApiResponse<ApiCallStateResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> modifyCall(String accountId, String callId, ApiModifyCallRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildModifyCallRequest(accountId, callId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleModifyCallResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> modifyCallAsync(String accountId, String callId, ApiModifyCallRequest body) {
        return this.makeHttpCallAsync(() -> this.buildModifyCallRequest(accountId, callId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleModifyCallResponse(context));
    }

    private HttpRequest buildModifyCallRequest(String accountId, String callId, ApiModifyCallRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        return request;
    }

    private ApiResponse<Void> handleModifyCallResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Void> modifyCallRecordingState(String accountId, String callId, ModifyCallRecordingState body) throws ApiException, IOException {
        HttpRequest request = this.buildModifyCallRecordingStateRequest(accountId, callId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleModifyCallRecordingStateResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> modifyCallRecordingStateAsync(String accountId, String callId, ModifyCallRecordingState body) {
        return this.makeHttpCallAsync(() -> this.buildModifyCallRecordingStateRequest(accountId, callId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleModifyCallRecordingStateResponse(context));
    }

    private HttpRequest buildModifyCallRecordingStateRequest(String accountId, String callId, ModifyCallRecordingState body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recording");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        return request;
    }

    private ApiResponse<Void> handleModifyCallRecordingStateResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<List<RecordingMetadataResponse>> getQueryMetadataForAccountAndCall(String accountId, String callId) throws ApiException, IOException {
        HttpRequest request = this.buildGetQueryMetadataForAccountAndCallRequest(accountId, callId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetQueryMetadataForAccountAndCallResponse(context);
    }

    public CompletableFuture<ApiResponse<List<RecordingMetadataResponse>>> getQueryMetadataForAccountAndCallAsync(String accountId, String callId) {
        return this.makeHttpCallAsync(() -> this.buildGetQueryMetadataForAccountAndCallRequest(accountId, callId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetQueryMetadataForAccountAndCallResponse(context));
    }

    private HttpRequest buildGetQueryMetadataForAccountAndCallRequest(String accountId, String callId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<List<RecordingMetadataResponse>> handleGetQueryMetadataForAccountAndCallResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, RecordingMetadataResponse[].class);
        return new ApiResponse<List<RecordingMetadataResponse>>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<RecordingMetadataResponse> getMetadataForRecording(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetMetadataForRecordingRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetMetadataForRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<RecordingMetadataResponse>> getMetadataForRecordingAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetMetadataForRecordingRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetMetadataForRecordingResponse(context));
    }

    private HttpRequest buildGetMetadataForRecordingRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<RecordingMetadataResponse> handleGetMetadataForRecordingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RecordingMetadataResponse result = ApiHelper.deserialize(responseBody, RecordingMetadataResponse.class);
        return new ApiResponse<RecordingMetadataResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> deleteRecording(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteRecordingRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRecordingAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteRecordingRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleDeleteRecordingResponse(context));
    }

    private HttpRequest buildDeleteRecordingRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<Void> handleDeleteRecordingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<InputStream> getStreamRecordingMedia(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetStreamRecordingMediaRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsBinary(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetStreamRecordingMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<InputStream>> getStreamRecordingMediaAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetStreamRecordingMediaRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetStreamRecordingMediaResponse(context));
    }

    private HttpRequest buildGetStreamRecordingMediaRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/media");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<InputStream> handleGetStreamRecordingMediaResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        InputStream result = response.getRawBody();
        return new ApiResponse<InputStream>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> deleteRecordingMedia(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteRecordingMediaRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteRecordingMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRecordingMediaAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteRecordingMediaRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleDeleteRecordingMediaResponse(context));
    }

    private HttpRequest buildDeleteRecordingMediaRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/media");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<Void> handleDeleteRecordingMediaResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<TranscriptionResponse> getRecordingTranscription(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetRecordingTranscriptionRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetRecordingTranscriptionResponse(context);
    }

    public CompletableFuture<ApiResponse<TranscriptionResponse>> getRecordingTranscriptionAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetRecordingTranscriptionRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetRecordingTranscriptionResponse(context));
    }

    private HttpRequest buildGetRecordingTranscriptionRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/transcription");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<TranscriptionResponse> handleGetRecordingTranscriptionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        TranscriptionResponse result = ApiHelper.deserialize(responseBody, TranscriptionResponse.class);
        return new ApiResponse<TranscriptionResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> createTranscribeRecording(String accountId, String callId, String recordingId, ApiTranscribeRecordingRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateTranscribeRecordingRequest(accountId, callId, recordingId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateTranscribeRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> createTranscribeRecordingAsync(String accountId, String callId, String recordingId, ApiTranscribeRecordingRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateTranscribeRecordingRequest(accountId, callId, recordingId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleCreateTranscribeRecordingResponse(context));
    }

    private HttpRequest buildCreateTranscribeRecordingRequest(String accountId, String callId, String recordingId, ApiTranscribeRecordingRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/transcription");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        return request;
    }

    private ApiResponse<Void> handleCreateTranscribeRecordingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 410) {
            throw new ApiErrorResponseException("The media for this recording has been deleted, so we can't transcribe it", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Void> deleteRecordingTranscription(String accountId, String callId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteRecordingTranscriptionRequest(accountId, callId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteRecordingTranscriptionResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRecordingTranscriptionAsync(String accountId, String callId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteRecordingTranscriptionRequest(accountId, callId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleDeleteRecordingTranscriptionResponse(context));
    }

    private HttpRequest buildDeleteRecordingTranscriptionRequest(String accountId, String callId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/calls/{callId}/recordings/{recordingId}/transcription");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<Void> handleDeleteRecordingTranscriptionResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<List<ConferenceDetail>> getConferencesByAccount(String accountId, Integer pageSize, String pageToken, String name, String minCreatedTime, String maxCreatedTime) throws ApiException, IOException {
        HttpRequest request = this.buildGetConferencesByAccountRequest(accountId, pageSize, pageToken, name, minCreatedTime, maxCreatedTime);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetConferencesByAccountResponse(context);
    }

    public CompletableFuture<ApiResponse<List<ConferenceDetail>>> getConferencesByAccountAsync(String accountId, Integer pageSize, String pageToken, String name, String minCreatedTime, String maxCreatedTime) {
        return this.makeHttpCallAsync(() -> this.buildGetConferencesByAccountRequest(accountId, pageSize, pageToken, name, minCreatedTime, maxCreatedTime), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetConferencesByAccountResponse(context));
    }

    private HttpRequest buildGetConferencesByAccountRequest(String accountId, Integer pageSize, String pageToken, String name, String minCreatedTime, String maxCreatedTime) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("pageSize", pageSize != null ? pageSize : 1000);
        queryParameters.put("pageToken", pageToken);
        queryParameters.put("name", name);
        queryParameters.put("minCreatedTime", minCreatedTime);
        queryParameters.put("maxCreatedTime", maxCreatedTime);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        return request;
    }

    private ApiResponse<List<ConferenceDetail>> handleGetConferencesByAccountResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, ConferenceDetail[].class);
        return new ApiResponse<List<ConferenceDetail>>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<ConferenceDetail> getConferenceById(String accountId, String conferenceId) throws ApiException, IOException {
        HttpRequest request = this.buildGetConferenceByIdRequest(accountId, conferenceId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetConferenceByIdResponse(context);
    }

    public CompletableFuture<ApiResponse<ConferenceDetail>> getConferenceByIdAsync(String accountId, String conferenceId) {
        return this.makeHttpCallAsync(() -> this.buildGetConferenceByIdRequest(accountId, conferenceId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetConferenceByIdResponse(context));
    }

    private HttpRequest buildGetConferenceByIdRequest(String accountId, String conferenceId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<ConferenceDetail> handleGetConferenceByIdResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ConferenceDetail result = ApiHelper.deserialize(responseBody, ConferenceDetail.class);
        return new ApiResponse<ConferenceDetail>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> modifyConference(String accountId, String conferenceId, CallEngineModifyConferenceRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildModifyConferenceRequest(accountId, conferenceId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleModifyConferenceResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> modifyConferenceAsync(String accountId, String conferenceId, CallEngineModifyConferenceRequest body) {
        return this.makeHttpCallAsync(() -> this.buildModifyConferenceRequest(accountId, conferenceId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleModifyConferenceResponse(context));
    }

    private HttpRequest buildModifyConferenceRequest(String accountId, String conferenceId, CallEngineModifyConferenceRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        return request;
    }

    private ApiResponse<Void> handleModifyConferenceResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Void> modifyConferenceMember(String accountId, String conferenceId, String callId, ConferenceMemberDetail body) throws ApiException, IOException {
        HttpRequest request = this.buildModifyConferenceMemberRequest(accountId, conferenceId, callId, body);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleModifyConferenceMemberResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> modifyConferenceMemberAsync(String accountId, String conferenceId, String callId, ConferenceMemberDetail body) {
        return this.makeHttpCallAsync(() -> this.buildModifyConferenceMemberRequest(accountId, conferenceId, callId, body), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleModifyConferenceMemberResponse(context));
    }

    private HttpRequest buildModifyConferenceMemberRequest(String accountId, String conferenceId, String callId, ConferenceMemberDetail body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/members/{callId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, true));
        templateParameters.put("callId", new AbstractMap.SimpleEntry<String, Boolean>(callId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, bodyJson);
        return request;
    }

    private ApiResponse<Void> handleModifyConferenceMemberResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<ConferenceMemberDetail> getConferenceMember(String accountId, String conferenceId, String memberId) throws ApiException, IOException {
        HttpRequest request = this.buildGetConferenceMemberRequest(accountId, conferenceId, memberId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetConferenceMemberResponse(context);
    }

    public CompletableFuture<ApiResponse<ConferenceMemberDetail>> getConferenceMemberAsync(String accountId, String conferenceId, String memberId) {
        return this.makeHttpCallAsync(() -> this.buildGetConferenceMemberRequest(accountId, conferenceId, memberId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetConferenceMemberResponse(context));
    }

    private HttpRequest buildGetConferenceMemberRequest(String accountId, String conferenceId, String memberId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/members/{memberId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, true));
        templateParameters.put("memberId", new AbstractMap.SimpleEntry<String, Boolean>(memberId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<ConferenceMemberDetail> handleGetConferenceMemberResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        ConferenceMemberDetail result = ApiHelper.deserialize(responseBody, ConferenceMemberDetail.class);
        return new ApiResponse<ConferenceMemberDetail>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<List<ConferenceRecordingMetadataResponse>> getQueryMetadataForAccountAndConference(String accountId, String conferenceId) throws ApiException, IOException {
        HttpRequest request = this.buildGetQueryMetadataForAccountAndConferenceRequest(accountId, conferenceId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetQueryMetadataForAccountAndConferenceResponse(context);
    }

    public CompletableFuture<ApiResponse<List<ConferenceRecordingMetadataResponse>>> getQueryMetadataForAccountAndConferenceAsync(String accountId, String conferenceId) {
        return this.makeHttpCallAsync(() -> this.buildGetQueryMetadataForAccountAndConferenceRequest(accountId, conferenceId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetQueryMetadataForAccountAndConferenceResponse(context));
    }

    private HttpRequest buildGetQueryMetadataForAccountAndConferenceRequest(String accountId, String conferenceId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/recordings");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<List<ConferenceRecordingMetadataResponse>> handleGetQueryMetadataForAccountAndConferenceResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, ConferenceRecordingMetadataResponse[].class);
        return new ApiResponse<List<ConferenceRecordingMetadataResponse>>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<RecordingMetadataResponse> getMetadataForConferenceRecording(String accountId, String conferenceId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetMetadataForConferenceRecordingRequest(accountId, conferenceId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetMetadataForConferenceRecordingResponse(context);
    }

    public CompletableFuture<ApiResponse<RecordingMetadataResponse>> getMetadataForConferenceRecordingAsync(String accountId, String conferenceId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetMetadataForConferenceRecordingRequest(accountId, conferenceId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetMetadataForConferenceRecordingResponse(context));
    }

    private HttpRequest buildGetMetadataForConferenceRecordingRequest(String accountId, String conferenceId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/recordings/{recordingId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, true));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<RecordingMetadataResponse> handleGetMetadataForConferenceRecordingResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        RecordingMetadataResponse result = ApiHelper.deserialize(responseBody, RecordingMetadataResponse.class);
        return new ApiResponse<RecordingMetadataResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<InputStream> getStreamConferenceRecordingMedia(String accountId, String conferenceId, String recordingId) throws ApiException, IOException {
        HttpRequest request = this.buildGetStreamConferenceRecordingMediaRequest(accountId, conferenceId, recordingId);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsBinary(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetStreamConferenceRecordingMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<InputStream>> getStreamConferenceRecordingMediaAsync(String accountId, String conferenceId, String recordingId) {
        return this.makeHttpCallAsync(() -> this.buildGetStreamConferenceRecordingMediaRequest(accountId, conferenceId, recordingId), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetStreamConferenceRecordingMediaResponse(context));
    }

    private HttpRequest buildGetStreamConferenceRecordingMediaRequest(String accountId, String conferenceId, String recordingId) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/conferences/{conferenceId}/recordings/{recordingId}/media");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        templateParameters.put("conferenceId", new AbstractMap.SimpleEntry<String, Boolean>(conferenceId, true));
        templateParameters.put("recordingId", new AbstractMap.SimpleEntry<String, Boolean>(recordingId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        return request;
    }

    private ApiResponse<InputStream> handleGetStreamConferenceRecordingMediaResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        InputStream result = response.getRawBody();
        return new ApiResponse<InputStream>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<List<RecordingMetadataResponse>> getQueryMetadataForAccount(String accountId, String from, String to, String minStartTime, String maxStartTime) throws ApiException, IOException {
        HttpRequest request = this.buildGetQueryMetadataForAccountRequest(accountId, from, to, minStartTime, maxStartTime);
        ((AuthManager)this.authManagers.get("voice")).apply(request);
        HttpResponse response = this.getClientInstance().executeAsString(request);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetQueryMetadataForAccountResponse(context);
    }

    public CompletableFuture<ApiResponse<List<RecordingMetadataResponse>>> getQueryMetadataForAccountAsync(String accountId, String from, String to, String minStartTime, String maxStartTime) {
        return this.makeHttpCallAsync(() -> this.buildGetQueryMetadataForAccountRequest(accountId, from, to, minStartTime, maxStartTime), req -> ((AuthManager)this.authManagers.get("voice")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsStringAsync((HttpRequest)request)), context -> this.handleGetQueryMetadataForAccountResponse(context));
    }

    private HttpRequest buildGetQueryMetadataForAccountRequest(String accountId, String from, String to, String minStartTime, String maxStartTime) {
        String baseUri = this.config.getBaseUri(Server.VOICEDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/api/v2/accounts/{accountId}/recordings");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, true));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("from", from);
        queryParameters.put("to", to);
        queryParameters.put("minStartTime", minStartTime);
        queryParameters.put("maxStartTime", maxStartTime);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk-refs/tags/java3.10.0");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        return request;
    }

    private ApiResponse<List<RecordingMetadataResponse>> handleGetQueryMetadataForAccountResponse(HttpContext context) throws ApiException, IOException {
        HttpResponse response = context.getResponse();
        int responseCode = response.getStatusCode();
        if (responseCode == 400) {
            throw new ApiErrorResponseException("Something's not quite right... Your request is invalid. Please fix it before trying again.", context);
        }
        if (responseCode == 401) {
            throw new ApiException("Your credentials are invalid. Please use your Bandwidth dashboard credentials to authenticate to the API.", context);
        }
        if (responseCode == 403) {
            throw new ApiErrorResponseException("User unauthorized to perform this action.", context);
        }
        if (responseCode == 404) {
            throw new ApiErrorResponseException("The resource specified cannot be found or does not belong to you.", context);
        }
        if (responseCode == 415) {
            throw new ApiErrorResponseException("We don't support that media type. If a request body is required, please send it to us as `application/json`.", context);
        }
        if (responseCode == 429) {
            throw new ApiErrorResponseException("You're sending requests to this endpoint too frequently. Please slow your request rate down and try again.", context);
        }
        if (responseCode == 500) {
            throw new ApiErrorResponseException("Something unexpected happened. Please try again.", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, RecordingMetadataResponse[].class);
        return new ApiResponse<List<RecordingMetadataResponse>>(response.getStatusCode(), response.getHeaders(), result);
    }
}

