/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum StateEnum {
    DISCONNECTED,
    ANSWERED,
    INITIATED;

    private static TreeMap<String, StateEnum> valueMap;
    private String value;

    @JsonCreator
    public static StateEnum fromString(String toConvert) {
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public static List<String> toValue(List<StateEnum> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (StateEnum enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        StateEnum.DISCONNECTED.value = "disconnected";
        StateEnum.ANSWERED.value = "answered";
        StateEnum.INITIATED.value = "initiated";
        valueMap.put("disconnected", DISCONNECTED);
        valueMap.put("answered", ANSWERED);
        valueMap.put("initiated", INITIATED);
    }
}

