/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.voice.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;

public class Transcript {
    private String text;
    private Double confidence;

    public Transcript() {
    }

    public Transcript(String text, Double confidence) {
        this.text = text;
        this.confidence = confidence;
    }

    @JsonGetter(value="text")
    public String getText() {
        return this.text;
    }

    @JsonSetter(value="text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonGetter(value="confidence")
    public Double getConfidence() {
        return this.confidence;
    }

    @JsonSetter(value="confidence")
    public void setConfidence(Double confidence) {
        this.confidence = confidence;
    }

    public Builder toBuilder() {
        Builder builder = new Builder().text(this.getText()).confidence(this.getConfidence());
        return builder;
    }

    public static class Builder {
        private String text;
        private Double confidence;

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public Transcript build() {
            return new Transcript(this.text, this.confidence);
        }
    }
}

