/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.webrtc.models;

import com.bandwidth.webrtc.models.ParticipantSubscription;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

public class Subscriptions {
    private String sessionId;
    private List<ParticipantSubscription> participants;

    public Subscriptions() {
    }

    public Subscriptions(String sessionId, List<ParticipantSubscription> participants) {
        this.sessionId = sessionId;
        this.participants = participants;
    }

    @JsonGetter(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonSetter(value="sessionId")
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @JsonGetter(value="participants")
    public List<ParticipantSubscription> getParticipants() {
        return this.participants;
    }

    @JsonSetter(value="participants")
    public void setParticipants(List<ParticipantSubscription> participants) {
        this.participants = participants;
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.sessionId).participants(this.getParticipants());
        return builder;
    }

    public static class Builder {
        private String sessionId;
        private List<ParticipantSubscription> participants;

        public Builder() {
        }

        public Builder(String sessionId) {
            this.sessionId = sessionId;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder participants(List<ParticipantSubscription> participants) {
            this.participants = participants;
            return this;
        }

        public Subscriptions build() {
            return new Subscriptions(this.sessionId, this.participants);
        }
    }
}

