/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth;

import com.bandwidth.ApiHelper;
import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.Environment;
import com.bandwidth.MessagingBasicAuthCredentials;
import com.bandwidth.MessagingBasicAuthManager;
import com.bandwidth.MessagingClient;
import com.bandwidth.MultiFactorAuthBasicAuthCredentials;
import com.bandwidth.MultiFactorAuthBasicAuthManager;
import com.bandwidth.MultiFactorAuthClient;
import com.bandwidth.PhoneNumberLookupBasicAuthCredentials;
import com.bandwidth.PhoneNumberLookupBasicAuthManager;
import com.bandwidth.PhoneNumberLookupClient;
import com.bandwidth.Server;
import com.bandwidth.VoiceBasicAuthCredentials;
import com.bandwidth.VoiceBasicAuthManager;
import com.bandwidth.VoiceClient;
import com.bandwidth.WebRtcBasicAuthCredentials;
import com.bandwidth.WebRtcBasicAuthManager;
import com.bandwidth.WebRtcClient;
import com.bandwidth.http.client.HttpCallback;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpClientConfiguration;
import com.bandwidth.http.client.OkClient;
import com.bandwidth.http.client.ReadonlyHttpClientConfiguration;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public final class BandwidthClient
implements Configuration {
    private MessagingClient messagingClient;
    private MultiFactorAuthClient multiFactorAuthClient;
    private PhoneNumberLookupClient phoneNumberLookupClient;
    private VoiceClient voiceClient;
    private WebRtcClient webRtcClient;
    private final Environment environment;
    private final String baseUrl;
    private final HttpClient httpClient;
    private final ReadonlyHttpClientConfiguration httpClientConfig;
    private MessagingBasicAuthManager messagingBasicAuthManager;
    private MultiFactorAuthBasicAuthManager multiFactorAuthBasicAuthManager;
    private PhoneNumberLookupBasicAuthManager phoneNumberLookupBasicAuthManager;
    private VoiceBasicAuthManager voiceBasicAuthManager;
    private WebRtcBasicAuthManager webRtcBasicAuthManager;
    private Map<String, AuthManager> authManagers;
    private final HttpCallback httpCallback;

    private BandwidthClient(Environment environment, String baseUrl, HttpClient httpClient, ReadonlyHttpClientConfiguration httpClientConfig, String messagingBasicAuthUserName, String messagingBasicAuthPassword, String multiFactorAuthBasicAuthUserName, String multiFactorAuthBasicAuthPassword, String phoneNumberLookupBasicAuthUserName, String phoneNumberLookupBasicAuthPassword, String voiceBasicAuthUserName, String voiceBasicAuthPassword, String webRtcBasicAuthUserName, String webRtcBasicAuthPassword, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        this.environment = environment;
        this.baseUrl = baseUrl;
        this.httpClient = httpClient;
        this.httpClientConfig = httpClientConfig;
        this.httpCallback = httpCallback;
        Map<String, AuthManager> map = this.authManagers = authManagers == null ? new HashMap<String, AuthManager>() : new HashMap<String, AuthManager>(authManagers);
        if (this.authManagers.containsKey("messaging")) {
            this.messagingBasicAuthManager = (MessagingBasicAuthManager)this.authManagers.get("messaging");
        }
        if (!this.authManagers.containsKey("messaging") || !this.getMessagingBasicAuthCredentials().equals(messagingBasicAuthUserName, messagingBasicAuthPassword)) {
            this.messagingBasicAuthManager = new MessagingBasicAuthManager(messagingBasicAuthUserName, messagingBasicAuthPassword);
            this.authManagers.put("messaging", this.messagingBasicAuthManager);
        }
        if (this.authManagers.containsKey("multiFactorAuth")) {
            this.multiFactorAuthBasicAuthManager = (MultiFactorAuthBasicAuthManager)this.authManagers.get("multiFactorAuth");
        }
        if (!this.authManagers.containsKey("multiFactorAuth") || !this.getMultiFactorAuthBasicAuthCredentials().equals(multiFactorAuthBasicAuthUserName, multiFactorAuthBasicAuthPassword)) {
            this.multiFactorAuthBasicAuthManager = new MultiFactorAuthBasicAuthManager(multiFactorAuthBasicAuthUserName, multiFactorAuthBasicAuthPassword);
            this.authManagers.put("multiFactorAuth", this.multiFactorAuthBasicAuthManager);
        }
        if (this.authManagers.containsKey("phoneNumberLookup")) {
            this.phoneNumberLookupBasicAuthManager = (PhoneNumberLookupBasicAuthManager)this.authManagers.get("phoneNumberLookup");
        }
        if (!this.authManagers.containsKey("phoneNumberLookup") || !this.getPhoneNumberLookupBasicAuthCredentials().equals(phoneNumberLookupBasicAuthUserName, phoneNumberLookupBasicAuthPassword)) {
            this.phoneNumberLookupBasicAuthManager = new PhoneNumberLookupBasicAuthManager(phoneNumberLookupBasicAuthUserName, phoneNumberLookupBasicAuthPassword);
            this.authManagers.put("phoneNumberLookup", this.phoneNumberLookupBasicAuthManager);
        }
        if (this.authManagers.containsKey("voice")) {
            this.voiceBasicAuthManager = (VoiceBasicAuthManager)this.authManagers.get("voice");
        }
        if (!this.authManagers.containsKey("voice") || !this.getVoiceBasicAuthCredentials().equals(voiceBasicAuthUserName, voiceBasicAuthPassword)) {
            this.voiceBasicAuthManager = new VoiceBasicAuthManager(voiceBasicAuthUserName, voiceBasicAuthPassword);
            this.authManagers.put("voice", this.voiceBasicAuthManager);
        }
        if (this.authManagers.containsKey("webRtc")) {
            this.webRtcBasicAuthManager = (WebRtcBasicAuthManager)this.authManagers.get("webRtc");
        }
        if (!this.authManagers.containsKey("webRtc") || !this.getWebRtcBasicAuthCredentials().equals(webRtcBasicAuthUserName, webRtcBasicAuthPassword)) {
            this.webRtcBasicAuthManager = new WebRtcBasicAuthManager(webRtcBasicAuthUserName, webRtcBasicAuthPassword);
            this.authManagers.put("webRtc", this.webRtcBasicAuthManager);
        }
        this.messagingClient = new MessagingClient(this, httpCallback);
        this.multiFactorAuthClient = new MultiFactorAuthClient(this, httpCallback);
        this.phoneNumberLookupClient = new PhoneNumberLookupClient(this, httpCallback);
        this.voiceClient = new VoiceClient(this, httpCallback);
        this.webRtcClient = new WebRtcClient(this, httpCallback);
    }

    public static void shutdown() {
        OkClient.shutdown();
    }

    public MessagingClient getMessagingClient() {
        return this.messagingClient;
    }

    public MultiFactorAuthClient getMultiFactorAuthClient() {
        return this.multiFactorAuthClient;
    }

    public PhoneNumberLookupClient getPhoneNumberLookupClient() {
        return this.phoneNumberLookupClient;
    }

    public VoiceClient getVoiceClient() {
        return this.voiceClient;
    }

    public WebRtcClient getWebRtcClient() {
        return this.webRtcClient;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public ReadonlyHttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    @Override
    public MessagingBasicAuthCredentials getMessagingBasicAuthCredentials() {
        return this.messagingBasicAuthManager;
    }

    @Override
    public MultiFactorAuthBasicAuthCredentials getMultiFactorAuthBasicAuthCredentials() {
        return this.multiFactorAuthBasicAuthManager;
    }

    @Override
    public PhoneNumberLookupBasicAuthCredentials getPhoneNumberLookupBasicAuthCredentials() {
        return this.phoneNumberLookupBasicAuthManager;
    }

    @Override
    public VoiceBasicAuthCredentials getVoiceBasicAuthCredentials() {
        return this.voiceBasicAuthManager;
    }

    @Override
    public WebRtcBasicAuthCredentials getWebRtcBasicAuthCredentials() {
        return this.webRtcBasicAuthManager;
    }

    public Map<String, AuthManager> getAuthManagers() {
        return this.authManagers;
    }

    @Override
    @Deprecated
    public long timeout() {
        return this.httpClientConfig.getTimeout();
    }

    @Override
    public String getBaseUri(Server server) {
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> parameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        parameters.put("base_url", new AbstractMap.SimpleEntry<String, Boolean>(this.baseUrl, false));
        StringBuilder baseUrl = new StringBuilder(BandwidthClient.environmentMapper(this.environment, server));
        ApiHelper.appendUrlWithTemplateParameters(baseUrl, parameters);
        return baseUrl.toString();
    }

    @Override
    public String getBaseUri() {
        return this.getBaseUri(Server.ENUM_DEFAULT);
    }

    private static String environmentMapper(Environment environment, Server server) {
        if (environment.equals((Object)Environment.PRODUCTION)) {
            if (server.equals((Object)Server.ENUM_DEFAULT)) {
                return "api.bandwidth.com";
            }
            if (server.equals((Object)Server.MESSAGINGDEFAULT)) {
                return "https://messaging.bandwidth.com/api/v2";
            }
            if (server.equals((Object)Server.MULTIFACTORAUTHDEFAULT)) {
                return "https://mfa.bandwidth.com/api/v1";
            }
            if (server.equals((Object)Server.PHONENUMBERLOOKUPDEFAULT)) {
                return "https://numbers.bandwidth.com/api/v1";
            }
            if (server.equals((Object)Server.VOICEDEFAULT)) {
                return "https://voice.bandwidth.com";
            }
            if (server.equals((Object)Server.WEBRTCDEFAULT)) {
                return "https://api.webrtc.bandwidth.com/v1";
            }
        }
        if (environment.equals((Object)Environment.CUSTOM)) {
            if (server.equals((Object)Server.ENUM_DEFAULT)) {
                return "{base_url}";
            }
            if (server.equals((Object)Server.MESSAGINGDEFAULT)) {
                return "{base_url}";
            }
            if (server.equals((Object)Server.MULTIFACTORAUTHDEFAULT)) {
                return "{base_url}";
            }
            if (server.equals((Object)Server.PHONENUMBERLOOKUPDEFAULT)) {
                return "{base_url}";
            }
            if (server.equals((Object)Server.VOICEDEFAULT)) {
                return "{base_url}";
            }
            if (server.equals((Object)Server.WEBRTCDEFAULT)) {
                return "{base_url}";
            }
        }
        return "api.bandwidth.com";
    }

    public String toString() {
        return "BandwidthClient [environment=" + (Object)((Object)this.environment) + ", baseUrl=" + this.baseUrl + ", httpClientConfig=" + this.httpClientConfig + ", authManagers=" + this.authManagers + "]";
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.environment = this.getEnvironment();
        builder.baseUrl = this.getBaseUrl();
        builder.httpClient = this.getHttpClient();
        builder.messagingBasicAuthUserName = this.getMessagingBasicAuthCredentials().getBasicAuthUserName();
        builder.messagingBasicAuthPassword = this.getMessagingBasicAuthCredentials().getBasicAuthPassword();
        builder.multiFactorAuthBasicAuthUserName = this.getMultiFactorAuthBasicAuthCredentials().getBasicAuthUserName();
        builder.multiFactorAuthBasicAuthPassword = this.getMultiFactorAuthBasicAuthCredentials().getBasicAuthPassword();
        builder.phoneNumberLookupBasicAuthUserName = this.getPhoneNumberLookupBasicAuthCredentials().getBasicAuthUserName();
        builder.phoneNumberLookupBasicAuthPassword = this.getPhoneNumberLookupBasicAuthCredentials().getBasicAuthPassword();
        builder.voiceBasicAuthUserName = this.getVoiceBasicAuthCredentials().getBasicAuthUserName();
        builder.voiceBasicAuthPassword = this.getVoiceBasicAuthCredentials().getBasicAuthPassword();
        builder.webRtcBasicAuthUserName = this.getWebRtcBasicAuthCredentials().getBasicAuthUserName();
        builder.webRtcBasicAuthPassword = this.getWebRtcBasicAuthCredentials().getBasicAuthPassword();
        builder.authManagers = this.authManagers;
        builder.httpCallback = this.httpCallback;
        builder.httpClientConfig(configBldr -> {
            configBldr = ((HttpClientConfiguration)this.httpClientConfig).newBuilder();
        });
        return builder;
    }

    public static class Builder {
        private Environment environment = Environment.PRODUCTION;
        private String baseUrl = "https://www.example.com";
        private HttpClient httpClient;
        private String messagingBasicAuthUserName = "TODO: Replace";
        private String messagingBasicAuthPassword = "TODO: Replace";
        private String multiFactorAuthBasicAuthUserName = "TODO: Replace";
        private String multiFactorAuthBasicAuthPassword = "TODO: Replace";
        private String phoneNumberLookupBasicAuthUserName = "TODO: Replace";
        private String phoneNumberLookupBasicAuthPassword = "TODO: Replace";
        private String voiceBasicAuthUserName = "TODO: Replace";
        private String voiceBasicAuthPassword = "TODO: Replace";
        private String webRtcBasicAuthUserName = "TODO: Replace";
        private String webRtcBasicAuthPassword = "TODO: Replace";
        private Map<String, AuthManager> authManagers = null;
        private HttpCallback httpCallback = null;
        private HttpClientConfiguration.Builder httpClientConfigBuilder = new HttpClientConfiguration.Builder();

        public Builder messagingBasicAuthCredentials(String basicAuthUserName, String basicAuthPassword) {
            if (basicAuthUserName == null) {
                throw new NullPointerException("BasicAuthUserName cannot be null.");
            }
            if (basicAuthPassword == null) {
                throw new NullPointerException("BasicAuthPassword cannot be null.");
            }
            this.messagingBasicAuthUserName = basicAuthUserName;
            this.messagingBasicAuthPassword = basicAuthPassword;
            return this;
        }

        public Builder multiFactorAuthBasicAuthCredentials(String basicAuthUserName, String basicAuthPassword) {
            if (basicAuthUserName == null) {
                throw new NullPointerException("BasicAuthUserName cannot be null.");
            }
            if (basicAuthPassword == null) {
                throw new NullPointerException("BasicAuthPassword cannot be null.");
            }
            this.multiFactorAuthBasicAuthUserName = basicAuthUserName;
            this.multiFactorAuthBasicAuthPassword = basicAuthPassword;
            return this;
        }

        public Builder phoneNumberLookupBasicAuthCredentials(String basicAuthUserName, String basicAuthPassword) {
            if (basicAuthUserName == null) {
                throw new NullPointerException("BasicAuthUserName cannot be null.");
            }
            if (basicAuthPassword == null) {
                throw new NullPointerException("BasicAuthPassword cannot be null.");
            }
            this.phoneNumberLookupBasicAuthUserName = basicAuthUserName;
            this.phoneNumberLookupBasicAuthPassword = basicAuthPassword;
            return this;
        }

        public Builder voiceBasicAuthCredentials(String basicAuthUserName, String basicAuthPassword) {
            if (basicAuthUserName == null) {
                throw new NullPointerException("BasicAuthUserName cannot be null.");
            }
            if (basicAuthPassword == null) {
                throw new NullPointerException("BasicAuthPassword cannot be null.");
            }
            this.voiceBasicAuthUserName = basicAuthUserName;
            this.voiceBasicAuthPassword = basicAuthPassword;
            return this;
        }

        public Builder webRtcBasicAuthCredentials(String basicAuthUserName, String basicAuthPassword) {
            if (basicAuthUserName == null) {
                throw new NullPointerException("BasicAuthUserName cannot be null.");
            }
            if (basicAuthPassword == null) {
                throw new NullPointerException("BasicAuthPassword cannot be null.");
            }
            this.webRtcBasicAuthUserName = basicAuthUserName;
            this.webRtcBasicAuthPassword = basicAuthPassword;
            return this;
        }

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Deprecated
        public Builder timeout(long timeout) {
            this.httpClientConfigBuilder.timeout(timeout);
            return this;
        }

        public Builder httpCallback(HttpCallback httpCallback) {
            this.httpCallback = httpCallback;
            return this;
        }

        public Builder httpClientConfig(Consumer<HttpClientConfiguration.Builder> action) {
            action.accept(this.httpClientConfigBuilder);
            return this;
        }

        public BandwidthClient build() {
            HttpClientConfiguration httpClientConfig = this.httpClientConfigBuilder.build();
            this.httpClient = new OkClient(httpClientConfig);
            return new BandwidthClient(this.environment, this.baseUrl, this.httpClient, httpClientConfig, this.messagingBasicAuthUserName, this.messagingBasicAuthPassword, this.multiFactorAuthBasicAuthUserName, this.multiFactorAuthBasicAuthPassword, this.phoneNumberLookupBasicAuthUserName, this.phoneNumberLookupBasicAuthPassword, this.voiceBasicAuthUserName, this.voiceBasicAuthPassword, this.webRtcBasicAuthUserName, this.webRtcBasicAuthPassword, this.authManagers, this.httpCallback);
        }
    }
}

