/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeHelper {
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z");

    public static LocalDateTime fromUnixTimestamp(Long date) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(date), ZoneId.systemDefault());
    }

    public static LocalDateTime fromUnixTimestamp(String date) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(date)), ZoneId.systemDefault());
    }

    public static String toUnixTimestamp(LocalDateTime value) {
        return value == null ? null : Long.toString(value.toEpochSecond(ZoneOffset.UTC));
    }

    public static List<String> toUnixTimestamp(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDateTime value : values) {
            valuesAsString.add(DateTimeHelper.toUnixTimestamp(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toUnixTimestamp(Map<String, LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, LocalDateTime> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), DateTimeHelper.toUnixTimestamp(value.getValue()));
        }
        return valuesAsString;
    }

    public static Long toUnixTimestampLong(LocalDateTime value) {
        return value == null ? null : Long.valueOf(value.toEpochSecond(ZoneOffset.UTC));
    }

    public static List<Long> toUnixTimestampLong(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Long> valuesAsLong = new ArrayList<Long>();
        for (LocalDateTime value : values) {
            valuesAsLong.add(DateTimeHelper.toUnixTimestampLong(value));
        }
        return valuesAsLong;
    }

    public static Map<String, Long> toUnixTimestampLong(Map<String, LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, Long> valuesAsLong = new HashMap<String, Long>();
        for (Map.Entry<String, LocalDateTime> value : values.entrySet()) {
            valuesAsLong.put(value.getKey(), DateTimeHelper.toUnixTimestampLong(value.getValue()));
        }
        return valuesAsLong;
    }

    public static LocalDateTime fromRfc1123DateTime(String date) {
        return LocalDateTime.parse(date, RFC1123_DATE_TIME_FORMATTER);
    }

    public static String toRfc1123DateTime(LocalDateTime value) {
        return value == null ? null : RFC1123_DATE_TIME_FORMATTER.format(value.atZone(ZoneId.of("GMT")));
    }

    public static List<String> toRfc1123DateTime(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDateTime value : values) {
            valuesAsString.add(DateTimeHelper.toRfc1123DateTime(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toRfc1123DateTime(Map<String, LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, LocalDateTime> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), DateTimeHelper.toRfc1123DateTime(value.getValue()));
        }
        return valuesAsString;
    }

    public static LocalDateTime fromRfc8601DateTime(String date) {
        Pattern pattern = Pattern.compile("(Z|([+-])(\\d{2}:\\d{2}))$");
        Matcher patternMatcher = pattern.matcher(date);
        if (patternMatcher.find()) {
            OffsetDateTime parsed = OffsetDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
            return LocalDateTime.from(parsed.withOffsetSameInstant(ZoneOffset.UTC));
        }
        return LocalDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
    }

    public static String toRfc8601DateTime(LocalDateTime value) {
        return value == null ? null : value.toString() + "Z";
    }

    public static List<String> toRfc8601DateTime(List<LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDateTime value : values) {
            valuesAsString.add(DateTimeHelper.toRfc8601DateTime(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toRfc8601DateTime(Map<String, LocalDateTime> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, LocalDateTime> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), DateTimeHelper.toRfc8601DateTime(value.getValue()));
        }
        return valuesAsString;
    }

    public static LocalDate fromSimpleDate(String date) {
        return LocalDate.parse(date);
    }

    public static String toSimpleDate(LocalDate value) {
        return value == null ? null : value.toString();
    }

    public static List<String> toSimpleDate(List<LocalDate> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (LocalDate value : values) {
            valuesAsString.add(DateTimeHelper.toSimpleDate(value));
        }
        return valuesAsString;
    }

    public static Map<String, String> toSimpleDate(Map<String, LocalDate> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> valuesAsString = new HashMap<String, String>();
        for (Map.Entry<String, LocalDate> value : values.entrySet()) {
            valuesAsString.put(value.getKey(), DateTimeHelper.toSimpleDate(value.getValue()));
        }
        return valuesAsString;
    }

    public static class SimpleDateSerializer
    extends JsonSerializer<LocalDate> {
        public void serialize(LocalDate value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(DateTimeHelper.toSimpleDate(value));
        }
    }

    public static class SimpleDateDeserializer
    extends JsonDeserializer<LocalDate> {
        public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateTimeHelper.fromSimpleDate(jp.getValueAsString());
        }
    }

    public static class Rfc8601DateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(DateTimeHelper.toRfc8601DateTime(value));
        }
    }

    public static class Rfc8601DateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateTimeHelper.fromRfc8601DateTime(jp.getValueAsString());
        }
    }

    public static class Rfc1123DateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(DateTimeHelper.toRfc1123DateTime(value));
        }
    }

    public static class Rfc1123DateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateTimeHelper.fromRfc1123DateTime(jp.getValueAsString());
        }
    }

    public static class UnixTimestampSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)DateTimeHelper.toUnixTimestampLong(value));
        }
    }

    public static class UnixTimestampDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateTimeHelper.fromUnixTimestamp(jp.getValueAsString());
        }
    }
}

