/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth;

import com.bandwidth.AuthManager;
import com.bandwidth.WebRtcBasicAuthCredentials;
import com.bandwidth.http.request.HttpRequest;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;

public class WebRtcBasicAuthManager
implements AuthManager,
WebRtcBasicAuthCredentials {
    private String basicAuthUserName;
    private String basicAuthPassword;

    public WebRtcBasicAuthManager(String username, String password) {
        this.basicAuthUserName = username;
        this.basicAuthPassword = password;
    }

    @Override
    public String getBasicAuthUserName() {
        return this.basicAuthUserName;
    }

    @Override
    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    @Override
    public boolean equals(String basicAuthUserName, String basicAuthPassword) {
        return basicAuthUserName.equals(this.getBasicAuthUserName()) && basicAuthPassword.equals(this.getBasicAuthPassword());
    }

    public String toString() {
        return "WebRtcBasicAuthManager [basicAuthUserName=" + this.basicAuthUserName + ", basicAuthPassword=" + this.basicAuthPassword + "]";
    }

    @Override
    public HttpRequest apply(HttpRequest httpRequest) {
        String authCredentials = this.basicAuthUserName + ":" + this.basicAuthPassword;
        httpRequest.getHeaders().add("Authorization", "Basic " + Base64.getEncoder().encodeToString(authCredentials.getBytes()));
        return httpRequest;
    }

    @Override
    public CompletableFuture<HttpRequest> applyAsync(HttpRequest httpRequest) {
        String authCredentials = this.basicAuthUserName + ":" + this.basicAuthPassword;
        httpRequest.getHeaders().add("Authorization", "Basic " + Base64.getEncoder().encodeToString(authCredentials.getBytes()));
        return CompletableFuture.completedFuture(httpRequest);
    }
}

