/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.controllers;

import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.exceptions.ApiException;
import com.bandwidth.http.client.HttpCallback;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpContext;
import com.bandwidth.http.request.HttpRequest;
import com.bandwidth.http.response.ApiResponse;
import com.bandwidth.http.response.HttpResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public abstract class BaseController {
    protected static final String userAgent = "java-sdk";
    protected final Configuration config;
    protected final HttpCallback httpCallback;
    protected Map<String, AuthManager> authManagers;
    private HttpClient httpClient;

    protected BaseController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        this(config, httpClient, authManagers, null);
    }

    protected BaseController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        this.config = config;
        this.httpClient = httpClient;
        this.authManagers = authManagers;
        this.httpCallback = httpCallback;
    }

    public HttpCallback getHttpCallback() {
        return this.httpCallback;
    }

    public HttpClient getClientInstance() {
        return this.httpClient;
    }

    protected void validateResponse(HttpResponse response, HttpContext context) throws ApiException {
        int responseCode = response.getStatusCode();
        if (responseCode < 200 || responseCode > 208) {
            throw new ApiException("HTTP Response Not OK", context);
        }
    }

    public <T> CompletableFuture<ApiResponse<T>> makeHttpCallAsync(RequestSupplier requestSupplier, RequestExecutor requestExecutor, ResponseHandler<T> responseHandler) {
        HttpRequest request;
        try {
            request = requestSupplier.supply();
        }
        catch (Exception e) {
            CompletableFuture<ApiResponse<T>> futureResponse = new CompletableFuture<ApiResponse<T>>();
            futureResponse.completeExceptionally(e);
            return futureResponse;
        }
        return requestExecutor.execute(request).thenApplyAsync(response -> {
            HttpContext context = new HttpContext(request, (HttpResponse)response);
            try {
                return responseHandler.handle(context);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    protected static interface ResponseHandler<T> {
        public ApiResponse<T> handle(HttpContext var1) throws ApiException, IOException;
    }

    protected static interface RequestExecutor {
        public CompletableFuture<HttpResponse> execute(HttpRequest var1);
    }

    protected static interface RequestSupplier {
        public HttpRequest supply() throws ApiException, IOException;
    }
}

