/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.exceptions;

import com.bandwidth.ApiHelper;
import com.bandwidth.http.client.HttpContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

public class ApiException
extends Exception {
    private static final long serialVersionUID = 6424174253911720338L;
    private HttpContext httpContext;

    public ApiException(String reason) {
        super(reason);
    }

    public ApiException(String reason, HttpContext context) {
        super(reason);
        this.httpContext = context;
        if (context == null || context.getResponse() == null || context.getResponse().getRawBody() == null) {
            return;
        }
        try {
            JsonNode jsonNode = ApiHelper.mapper.readTree(context.getResponse().getRawBody());
            if (!this.getClass().equals(ApiException.class)) {
                ApiHelper.mapper.readerForUpdating((Object)this).readValue(jsonNode);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getResponseCode() {
        return this.httpContext != null ? this.httpContext.getResponse().getStatusCode() : -1;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }
}

