/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.http.client;

import com.bandwidth.http.client.ReadonlyHttpClientConfiguration;
import com.bandwidth.http.request.HttpMethod;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import okhttp3.OkHttpClient;

public class HttpClientConfiguration
implements ReadonlyHttpClientConfiguration {
    private final long timeout;
    private final int numberOfRetries;
    private final int backOffFactor;
    private final long retryInterval;
    private final Set<Integer> httpStatusCodesToRetry;
    private final Set<HttpMethod> httpMethodsToRetry;
    private final long maximumRetryWaitTime;
    private final boolean shouldRetryOnTimeout;
    private final OkHttpClient httpClientInstance;
    private final boolean overrideHttpClientConfigurations;

    private HttpClientConfiguration(long timeout, int numberOfRetries, int backOffFactor, long retryInterval, Set<Integer> httpStatusCodesToRetry, Set<HttpMethod> httpMethodsToRetry, long maximumRetryWaitTime, boolean shouldRetryOnTimeout, OkHttpClient httpClientInstance, boolean overrideHttpClientConfigurations) {
        this.timeout = timeout;
        this.numberOfRetries = numberOfRetries;
        this.backOffFactor = backOffFactor;
        this.retryInterval = retryInterval;
        this.httpStatusCodesToRetry = httpStatusCodesToRetry;
        this.httpMethodsToRetry = httpMethodsToRetry;
        this.maximumRetryWaitTime = maximumRetryWaitTime;
        this.shouldRetryOnTimeout = shouldRetryOnTimeout;
        this.httpClientInstance = httpClientInstance;
        this.overrideHttpClientConfigurations = overrideHttpClientConfigurations;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    @Override
    public int getBackOffFactor() {
        return this.backOffFactor;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public Set<Integer> getHttpStatusCodesToRetry() {
        return this.httpStatusCodesToRetry;
    }

    @Override
    public Set<HttpMethod> getHttpMethodsToRetry() {
        return this.httpMethodsToRetry;
    }

    @Override
    public long getMaximumRetryWaitTime() {
        return this.maximumRetryWaitTime;
    }

    @Override
    public boolean shouldRetryOnTimeout() {
        return this.shouldRetryOnTimeout;
    }

    @Override
    public OkHttpClient getHttpClientInstance() {
        return this.httpClientInstance;
    }

    @Override
    public boolean shouldOverrideHttpClientConfigurations() {
        return this.overrideHttpClientConfigurations;
    }

    public String toString() {
        return "HttpClientConfiguration [timeout=" + this.timeout + ", numberOfRetries=" + this.numberOfRetries + ", backOffFactor=" + this.backOffFactor + ", retryInterval=" + this.retryInterval + ", httpStatusCodesToRetry=" + this.httpStatusCodesToRetry + ", httpMethodsToRetry=" + this.httpMethodsToRetry + ", maximumRetryWaitTime=" + this.maximumRetryWaitTime + ", shouldRetryOnTimeout=" + this.shouldRetryOnTimeout + ", httpClientInstance=" + this.httpClientInstance + ", overrideHttpClientConfigurations=" + this.overrideHttpClientConfigurations + "]";
    }

    public Builder newBuilder() {
        return new Builder().timeout(this.timeout).numberOfRetries(this.numberOfRetries).backOffFactor(this.backOffFactor).retryInterval(this.retryInterval).httpStatusCodesToRetry(this.httpStatusCodesToRetry).httpMethodsToRetry(this.httpMethodsToRetry).maximumRetryWaitTime(this.maximumRetryWaitTime).shouldRetryOnTimeout(this.shouldRetryOnTimeout).httpClientInstance(this.httpClientInstance, this.overrideHttpClientConfigurations);
    }

    public static class Builder {
        private long timeout = 0L;
        private int numberOfRetries = 0;
        private int backOffFactor = 2;
        private long retryInterval = 1L;
        private Set<Integer> httpStatusCodesToRetry = new HashSet<Integer>();
        private Set<HttpMethod> httpMethodsToRetry = new HashSet<HttpMethod>();
        private long maximumRetryWaitTime = 0L;
        private boolean shouldRetryOnTimeout = true;
        private OkHttpClient httpClientInstance;
        private boolean overrideHttpClientConfigurations = true;

        public Builder() {
            this.httpStatusCodesToRetry.addAll(Arrays.asList(408, 413, 429, 500, 502, 503, 504, 521, 522, 524, 408, 413, 429, 500, 502, 503, 504, 521, 522, 524));
            this.httpMethodsToRetry.addAll(Arrays.asList(HttpMethod.GET, HttpMethod.PUT, HttpMethod.GET, HttpMethod.PUT));
        }

        public Builder timeout(long timeout) {
            if (timeout > 0L) {
                this.timeout = timeout;
            }
            return this;
        }

        public Builder numberOfRetries(int numberOfRetries) {
            if (numberOfRetries >= 0) {
                this.numberOfRetries = numberOfRetries;
            }
            return this;
        }

        public Builder backOffFactor(int backOffFactor) {
            if (backOffFactor >= 1) {
                this.backOffFactor = backOffFactor;
            }
            return this;
        }

        public Builder retryInterval(long retryInterval) {
            if (retryInterval >= 0L) {
                this.retryInterval = retryInterval;
            }
            return this;
        }

        public Builder httpStatusCodesToRetry(Set<Integer> httpStatusCodesToRetry) {
            this.httpStatusCodesToRetry.clear();
            if (httpStatusCodesToRetry != null) {
                this.httpStatusCodesToRetry.addAll(httpStatusCodesToRetry);
            }
            return this;
        }

        public Builder httpMethodsToRetry(Set<HttpMethod> httpMethodsToRetry) {
            this.httpMethodsToRetry.clear();
            if (httpMethodsToRetry != null) {
                this.httpMethodsToRetry.addAll(httpMethodsToRetry);
            }
            return this;
        }

        public Builder maximumRetryWaitTime(long maximumRetryWaitTime) {
            if (maximumRetryWaitTime > 0L) {
                this.maximumRetryWaitTime = maximumRetryWaitTime;
            }
            return this;
        }

        public Builder shouldRetryOnTimeout(boolean shouldRetryOnTimeout) {
            this.shouldRetryOnTimeout = shouldRetryOnTimeout;
            return this;
        }

        public Builder httpClientInstance(OkHttpClient httpClientInstance) {
            this.httpClientInstance = httpClientInstance;
            return this;
        }

        public Builder httpClientInstance(OkHttpClient httpClientInstance, boolean overrideHttpClientConfigurations) {
            this.httpClientInstance = httpClientInstance;
            this.overrideHttpClientConfigurations = overrideHttpClientConfigurations;
            return this;
        }

        public HttpClientConfiguration build() {
            return new HttpClientConfiguration(this.timeout, this.numberOfRetries, this.backOffFactor, this.retryInterval, this.httpStatusCodesToRetry, this.httpMethodsToRetry, this.maximumRetryWaitTime, this.shouldRetryOnTimeout, this.httpClientInstance, this.overrideHttpClientConfigurations);
        }
    }
}

