/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.http.client;

import com.bandwidth.http.client.ReadonlyHttpClientConfiguration;
import com.bandwidth.http.request.HttpMethod;
import java.io.IOException;
import java.net.SocketException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryInterceptor
implements Interceptor {
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z").withZone(ZoneId.of("GMT"));
    private final ConcurrentMap<Request, RequestState> requestEntries;
    private final ReadonlyHttpClientConfiguration httpClientConfiguration;

    public RetryInterceptor(ReadonlyHttpClientConfiguration httpClientConfig) {
        this.httpClientConfiguration = httpClientConfig;
        this.requestEntries = new ConcurrentHashMap<Request, RequestState>();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        RequestState requestState;
        Request request;
        block6: {
            request = chain.request();
            requestState = this.getRequestState(request);
            response = null;
            try {
                response = chain.proceed(request);
            }
            catch (IOException ioException) {
                if (!this.httpClientConfiguration.shouldRetryOnTimeout() || this.httpClientConfiguration.getNumberOfRetries() <= 0) break block6;
                response = this.retryOnTimeout(chain, request, requestState, ioException);
            }
        }
        while (requestState != null && this.needToRetry(request, response)) {
            requestState.retryCount++;
            this.calculateWaitTime(requestState, response);
            if (this.hasWaitTimeLimitExceeded(requestState)) break;
            this.holdExecution(requestState);
            try {
                response.close();
                response = chain.proceed(request);
            }
            catch (SocketException socketException) {
                response = chain.proceed(request);
            }
            catch (IOException ioException) {
                if (!this.httpClientConfiguration.shouldRetryOnTimeout() || this.httpClientConfiguration.getNumberOfRetries() <= 0) continue;
                response = this.retryOnTimeout(chain, request, requestState, ioException);
            }
        }
        this.requestEntries.remove(request);
        return response;
    }

    public void addRequestEntry(Request okHttpRequest) {
        this.requestEntries.put(okHttpRequest, new RequestState());
    }

    private boolean hasWaitTimeLimitExceeded(RequestState requestState) {
        return this.httpClientConfiguration.getMaximumRetryWaitTime() > 0L && this.toMilliseconds(this.httpClientConfiguration.getMaximumRetryWaitTime()) < requestState.totalWaitTimeInMilliSeconds;
    }

    private boolean needToRetry(Request request, Response response) {
        return this.getRequestState(request).retryCount < this.httpClientConfiguration.getNumberOfRetries() && this.httpClientConfiguration.getHttpMethodsToRetry().contains((Object)HttpMethod.valueOf(request.method())) && response != null && (this.httpClientConfiguration.getHttpStatusCodesToRetry().contains(response.code()) || this.hasRetryAfterHeader(response));
    }

    private void calculateWaitTime(RequestState requestState, Response response) {
        long calculatedBackOffInMilliSeconds;
        long retryAfterHeaderValue = 0L;
        if (this.hasRetryAfterHeader(response)) {
            retryAfterHeaderValue = this.getCalculatedHeaderValue(response.header("Retry-After"));
        }
        requestState.currentWaitInMilliSeconds = (calculatedBackOffInMilliSeconds = this.getCalculatedBackOffValue(requestState)) > retryAfterHeaderValue ? calculatedBackOffInMilliSeconds : retryAfterHeaderValue;
        requestState.totalWaitTimeInMilliSeconds += requestState.currentWaitInMilliSeconds;
    }

    private boolean hasRetryAfterHeader(Response response) {
        String retryAfter = response.header("Retry-After");
        return retryAfter != null && !retryAfter.isEmpty();
    }

    private long getCalculatedHeaderValue(String headerValue) {
        try {
            return this.toMilliseconds(Long.parseLong(headerValue));
        }
        catch (NumberFormatException nfe) {
            long requestAtValueInSeconds = LocalDateTime.parse(headerValue, RFC1123_DATE_TIME_FORMATTER).toEpochSecond(ZoneOffset.UTC);
            long currentDateTimeInSeconds = LocalDateTime.now(ZoneOffset.UTC).toEpochSecond(ZoneOffset.UTC);
            return this.toMilliseconds(requestAtValueInSeconds - currentDateTimeInSeconds);
        }
    }

    private long getCalculatedBackOffValue(RequestState requestState) {
        return (long)((double)(1000L * this.httpClientConfiguration.getRetryInterval()) * Math.pow(this.httpClientConfiguration.getBackOffFactor(), requestState.retryCount - 1) + Math.random() * 100.0);
    }

    private void holdExecution(RequestState requestState) {
        try {
            TimeUnit.MILLISECONDS.sleep(requestState.currentWaitInMilliSeconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long toMilliseconds(long seconds) {
        return seconds * 1000L;
    }

    private RequestState getRequestState(Request okHttpRequest) {
        return (RequestState)this.requestEntries.get(okHttpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response retryOnTimeout(Interceptor.Chain chain, Request request, RequestState requestState, IOException exception) throws IOException {
        while (requestState.retryCount++ < this.httpClientConfiguration.getNumberOfRetries() && !this.hasWaitTimeLimitExceeded(requestState)) {
            try {
                Response response = chain.proceed(request);
                return response;
            }
            catch (IOException ioException) {
                exception = ioException;
            }
            finally {
                requestState.totalWaitTimeInMilliSeconds += this.toMilliseconds(this.httpClientConfiguration.getTimeout());
            }
        }
        throw exception;
    }

    private class RequestState {
        private int retryCount = 0;
        private long currentWaitInMilliSeconds = 0L;
        private long totalWaitTimeInMilliSeconds = 0L;

        private RequestState() {
        }
    }
}

