/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.messaging.controllers;

import com.bandwidth.ApiHelper;
import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.Server;
import com.bandwidth.controllers.BaseController;
import com.bandwidth.exceptions.ApiException;
import com.bandwidth.http.Headers;
import com.bandwidth.http.client.HttpCallback;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpContext;
import com.bandwidth.http.request.HttpBodyRequest;
import com.bandwidth.http.request.HttpRequest;
import com.bandwidth.http.response.ApiResponse;
import com.bandwidth.http.response.HttpResponse;
import com.bandwidth.http.response.HttpStringResponse;
import com.bandwidth.messaging.exceptions.MessagingException;
import com.bandwidth.messaging.models.BandwidthMessage;
import com.bandwidth.messaging.models.BandwidthMessagesList;
import com.bandwidth.messaging.models.Media;
import com.bandwidth.messaging.models.MessageRequest;
import com.bandwidth.utilities.FileWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class APIController
extends BaseController {
    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public APIController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    public ApiResponse<List<Media>> listMedia(String accountId, String continuationToken) throws ApiException, IOException {
        HttpRequest request = this.buildListMediaRequest(accountId, continuationToken);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleListMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<List<Media>>> listMediaAsync(String accountId, String continuationToken) {
        return this.makeHttpCallAsync(() -> this.buildListMediaRequest(accountId, continuationToken), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleListMediaResponse(context));
    }

    private HttpRequest buildListMediaRequest(String accountId, String continuationToken) {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{accountId}/media");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Continuation-Token", continuationToken);
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<List<Media>> handleListMediaResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        List result = ApiHelper.deserializeArray(responseBody, Media[].class);
        return new ApiResponse<List<Media>>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<InputStream> getMedia(String accountId, String mediaId) throws ApiException, IOException {
        HttpRequest request = this.buildGetMediaRequest(accountId, mediaId);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, true);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<InputStream>> getMediaAsync(String accountId, String mediaId) {
        return this.makeHttpCallAsync(() -> this.buildGetMediaRequest(accountId, mediaId), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetMediaResponse(context));
    }

    private HttpRequest buildGetMediaRequest(String accountId, String mediaId) {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{accountId}/media/{mediaId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("mediaId", new AbstractMap.SimpleEntry<String, Boolean>(mediaId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<InputStream> handleGetMediaResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        InputStream result = response.getRawBody();
        return new ApiResponse<InputStream>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<Void> uploadMedia(String accountId, String mediaId, FileWrapper body, String contentType, String cacheControl) throws ApiException, IOException {
        HttpRequest request = this.buildUploadMediaRequest(accountId, mediaId, body, contentType, cacheControl);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleUploadMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> uploadMediaAsync(String accountId, String mediaId, FileWrapper body, String contentType, String cacheControl) {
        return this.makeHttpCallAsync(() -> this.buildUploadMediaRequest(accountId, mediaId, body, contentType, cacheControl), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleUploadMediaResponse(context));
    }

    private HttpRequest buildUploadMediaRequest(String accountId, String mediaId, FileWrapper body, String contentType, String cacheControl) {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{accountId}/media/{mediaId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("mediaId", new AbstractMap.SimpleEntry<String, Boolean>(mediaId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("Content-Type", contentType != null ? contentType : "application/octet-stream");
        headers.add("Cache-Control", cacheControl);
        headers.add("user-agent", "java-sdk");
        HttpBodyRequest request = this.getClientInstance().putBody(queryBuilder, headers, null, body);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleUploadMediaResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<Void> deleteMedia(String accountId, String mediaId) throws ApiException, IOException {
        HttpRequest request = this.buildDeleteMediaRequest(accountId, mediaId);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleDeleteMediaResponse(context);
    }

    public CompletableFuture<ApiResponse<Void>> deleteMediaAsync(String accountId, String mediaId) {
        return this.makeHttpCallAsync(() -> this.buildDeleteMediaRequest(accountId, mediaId), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleDeleteMediaResponse(context));
    }

    private HttpRequest buildDeleteMediaRequest(String accountId, String mediaId) {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{accountId}/media/{mediaId}");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        templateParameters.put("mediaId", new AbstractMap.SimpleEntry<String, Boolean>(mediaId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        HttpRequest request = this.getClientInstance().delete(queryBuilder, headers, null, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<Void> handleDeleteMediaResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        return new ApiResponse<Object>(response.getStatusCode(), response.getHeaders(), null);
    }

    public ApiResponse<BandwidthMessagesList> getMessages(String accountId, String messageId, String sourceTn, String destinationTn, String messageStatus, Integer errorCode, String fromDateTime, String toDateTime, String pageToken, Integer limit) throws ApiException, IOException {
        HttpRequest request = this.buildGetMessagesRequest(accountId, messageId, sourceTn, destinationTn, messageStatus, errorCode, fromDateTime, toDateTime, pageToken, limit);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleGetMessagesResponse(context);
    }

    public CompletableFuture<ApiResponse<BandwidthMessagesList>> getMessagesAsync(String accountId, String messageId, String sourceTn, String destinationTn, String messageStatus, Integer errorCode, String fromDateTime, String toDateTime, String pageToken, Integer limit) {
        return this.makeHttpCallAsync(() -> this.buildGetMessagesRequest(accountId, messageId, sourceTn, destinationTn, messageStatus, errorCode, fromDateTime, toDateTime, pageToken, limit), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleGetMessagesResponse(context));
    }

    private HttpRequest buildGetMessagesRequest(String accountId, String messageId, String sourceTn, String destinationTn, String messageStatus, Integer errorCode, String fromDateTime, String toDateTime, String pageToken, Integer limit) {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{accountId}/messages");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("messageId", messageId);
        queryParameters.put("sourceTn", sourceTn);
        queryParameters.put("destinationTn", destinationTn);
        queryParameters.put("messageStatus", messageStatus);
        queryParameters.put("errorCode", errorCode);
        queryParameters.put("fromDateTime", fromDateTime);
        queryParameters.put("toDateTime", toDateTime);
        queryParameters.put("pageToken", pageToken);
        queryParameters.put("limit", limit);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        HttpRequest request = this.getClientInstance().get(queryBuilder, headers, queryParameters, null);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<BandwidthMessagesList> handleGetMessagesResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BandwidthMessagesList result = ApiHelper.deserialize(responseBody, BandwidthMessagesList.class);
        return new ApiResponse<BandwidthMessagesList>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<BandwidthMessage> createMessage(String accountId, MessageRequest body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateMessageRequest(accountId, body);
        ((AuthManager)this.authManagers.get("messaging")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateMessageResponse(context);
    }

    public CompletableFuture<ApiResponse<BandwidthMessage>> createMessageAsync(String accountId, MessageRequest body) {
        return this.makeHttpCallAsync(() -> this.buildCreateMessageRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("messaging")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateMessageResponse(context));
    }

    private HttpRequest buildCreateMessageRequest(String accountId, MessageRequest body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.MESSAGINGDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/users/{accountId}/messages");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<BandwidthMessage> handleCreateMessageResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new MessagingException("400 Request is malformed or invalid", context);
        }
        if (responseCode == 401) {
            throw new MessagingException("401 The specified user does not have access to the account", context);
        }
        if (responseCode == 403) {
            throw new MessagingException("403 The user does not have access to this API", context);
        }
        if (responseCode == 404) {
            throw new MessagingException("404 Path not found", context);
        }
        if (responseCode == 415) {
            throw new MessagingException("415 The content-type of the request is incorrect", context);
        }
        if (responseCode == 429) {
            throw new MessagingException("429 The rate limit has been reached", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        BandwidthMessage result = ApiHelper.deserialize(responseBody, BandwidthMessage.class);
        return new ApiResponse<BandwidthMessage>(response.getStatusCode(), response.getHeaders(), result);
    }
}

