/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.messaging.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class Media {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String content;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer contentLength;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String mediaName;

    public Media() {
    }

    public Media(String content, Integer contentLength, String mediaName) {
        this.content = content;
        this.contentLength = contentLength;
        this.mediaName = mediaName;
    }

    @JsonGetter(value="content")
    public String getContent() {
        return this.content;
    }

    @JsonSetter(value="content")
    public void setContent(String content) {
        this.content = content;
    }

    @JsonGetter(value="contentLength")
    public Integer getContentLength() {
        return this.contentLength;
    }

    @JsonSetter(value="contentLength")
    public void setContentLength(Integer contentLength) {
        this.contentLength = contentLength;
    }

    @JsonGetter(value="mediaName")
    public String getMediaName() {
        return this.mediaName;
    }

    @JsonSetter(value="mediaName")
    public void setMediaName(String mediaName) {
        this.mediaName = mediaName;
    }

    public String toString() {
        return "Media [content=" + this.content + ", contentLength=" + this.contentLength + ", mediaName=" + this.mediaName + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().content(this.getContent()).contentLength(this.getContentLength()).mediaName(this.getMediaName());
        return builder;
    }

    public static class Builder {
        private String content;
        private Integer contentLength;
        private String mediaName;

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder contentLength(Integer contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder mediaName(String mediaName) {
            this.mediaName = mediaName;
            return this;
        }

        public Media build() {
            return new Media(this.content, this.contentLength, this.mediaName);
        }
    }
}

