/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.multifactorauth.controllers;

import com.bandwidth.ApiHelper;
import com.bandwidth.AuthManager;
import com.bandwidth.Configuration;
import com.bandwidth.Server;
import com.bandwidth.controllers.BaseController;
import com.bandwidth.exceptions.ApiException;
import com.bandwidth.http.Headers;
import com.bandwidth.http.client.HttpCallback;
import com.bandwidth.http.client.HttpClient;
import com.bandwidth.http.client.HttpContext;
import com.bandwidth.http.request.HttpBodyRequest;
import com.bandwidth.http.request.HttpRequest;
import com.bandwidth.http.response.ApiResponse;
import com.bandwidth.http.response.HttpResponse;
import com.bandwidth.http.response.HttpStringResponse;
import com.bandwidth.multifactorauth.exceptions.ErrorWithRequestException;
import com.bandwidth.multifactorauth.exceptions.ForbiddenRequestException;
import com.bandwidth.multifactorauth.exceptions.UnauthorizedRequestException;
import com.bandwidth.multifactorauth.models.TwoFactorCodeRequestSchema;
import com.bandwidth.multifactorauth.models.TwoFactorMessagingResponse;
import com.bandwidth.multifactorauth.models.TwoFactorVerifyCodeResponse;
import com.bandwidth.multifactorauth.models.TwoFactorVerifyRequestSchema;
import com.bandwidth.multifactorauth.models.TwoFactorVoiceResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class MFAController
extends BaseController {
    public MFAController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers) {
        super(config, httpClient, authManagers);
    }

    public MFAController(Configuration config, HttpClient httpClient, Map<String, AuthManager> authManagers, HttpCallback httpCallback) {
        super(config, httpClient, authManagers, httpCallback);
    }

    public ApiResponse<TwoFactorVoiceResponse> createVoiceTwoFactor(String accountId, TwoFactorCodeRequestSchema body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateVoiceTwoFactorRequest(accountId, body);
        ((AuthManager)this.authManagers.get("multiFactorAuth")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateVoiceTwoFactorResponse(context);
    }

    public CompletableFuture<ApiResponse<TwoFactorVoiceResponse>> createVoiceTwoFactorAsync(String accountId, TwoFactorCodeRequestSchema body) {
        return this.makeHttpCallAsync(() -> this.buildCreateVoiceTwoFactorRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("multiFactorAuth")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateVoiceTwoFactorResponse(context));
    }

    private HttpRequest buildCreateVoiceTwoFactorRequest(String accountId, TwoFactorCodeRequestSchema body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.MULTIFACTORAUTHDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/code/voice");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<TwoFactorVoiceResponse> handleCreateVoiceTwoFactorResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ErrorWithRequestException("If there is any issue with values passed in by the user", context);
        }
        if (responseCode == 401) {
            throw new UnauthorizedRequestException("Authentication is either incorrect or not present", context);
        }
        if (responseCode == 403) {
            throw new ForbiddenRequestException("The user is not authorized to access this resource", context);
        }
        if (responseCode == 500) {
            throw new ErrorWithRequestException("An internal server error occurred", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        TwoFactorVoiceResponse result = ApiHelper.deserialize(responseBody, TwoFactorVoiceResponse.class);
        return new ApiResponse<TwoFactorVoiceResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<TwoFactorMessagingResponse> createMessagingTwoFactor(String accountId, TwoFactorCodeRequestSchema body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateMessagingTwoFactorRequest(accountId, body);
        ((AuthManager)this.authManagers.get("multiFactorAuth")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateMessagingTwoFactorResponse(context);
    }

    public CompletableFuture<ApiResponse<TwoFactorMessagingResponse>> createMessagingTwoFactorAsync(String accountId, TwoFactorCodeRequestSchema body) {
        return this.makeHttpCallAsync(() -> this.buildCreateMessagingTwoFactorRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("multiFactorAuth")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateMessagingTwoFactorResponse(context));
    }

    private HttpRequest buildCreateMessagingTwoFactorRequest(String accountId, TwoFactorCodeRequestSchema body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.MULTIFACTORAUTHDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/code/messaging");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<TwoFactorMessagingResponse> handleCreateMessagingTwoFactorResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ErrorWithRequestException("If there is any issue with values passed in by the user", context);
        }
        if (responseCode == 401) {
            throw new UnauthorizedRequestException("Authentication is either incorrect or not present", context);
        }
        if (responseCode == 403) {
            throw new ForbiddenRequestException("The user is not authorized to access this resource", context);
        }
        if (responseCode == 500) {
            throw new ErrorWithRequestException("An internal server error occurred", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        TwoFactorMessagingResponse result = ApiHelper.deserialize(responseBody, TwoFactorMessagingResponse.class);
        return new ApiResponse<TwoFactorMessagingResponse>(response.getStatusCode(), response.getHeaders(), result);
    }

    public ApiResponse<TwoFactorVerifyCodeResponse> createVerifyTwoFactor(String accountId, TwoFactorVerifyRequestSchema body) throws ApiException, IOException {
        HttpRequest request = this.buildCreateVerifyTwoFactorRequest(accountId, body);
        ((AuthManager)this.authManagers.get("multiFactorAuth")).apply(request);
        HttpResponse response = this.getClientInstance().execute(request, false);
        HttpContext context = new HttpContext(request, response);
        return this.handleCreateVerifyTwoFactorResponse(context);
    }

    public CompletableFuture<ApiResponse<TwoFactorVerifyCodeResponse>> createVerifyTwoFactorAsync(String accountId, TwoFactorVerifyRequestSchema body) {
        return this.makeHttpCallAsync(() -> this.buildCreateVerifyTwoFactorRequest(accountId, body), req -> ((AuthManager)this.authManagers.get("multiFactorAuth")).applyAsync(req).thenCompose(request -> this.getClientInstance().executeAsync((HttpRequest)request, false)), context -> this.handleCreateVerifyTwoFactorResponse(context));
    }

    private HttpRequest buildCreateVerifyTwoFactorRequest(String accountId, TwoFactorVerifyRequestSchema body) throws JsonProcessingException {
        String baseUri = this.config.getBaseUri(Server.MULTIFACTORAUTHDEFAULT);
        StringBuilder queryBuilder = new StringBuilder(baseUri + "/accounts/{accountId}/code/verify");
        HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParameters = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        templateParameters.put("accountId", new AbstractMap.SimpleEntry<String, Boolean>(accountId, false));
        ApiHelper.appendUrlWithTemplateParameters(queryBuilder, templateParameters);
        Headers headers = new Headers();
        headers.add("user-agent", "java-sdk");
        headers.add("accept", "application/json");
        headers.add("content-type", "application/json");
        String bodyJson = ApiHelper.serialize(body);
        HttpBodyRequest request = this.getClientInstance().postBody(queryBuilder, headers, null, bodyJson);
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onBeforeRequest(request);
        }
        return request;
    }

    private ApiResponse<TwoFactorVerifyCodeResponse> handleCreateVerifyTwoFactorResponse(HttpContext context) throws ApiException, IOException {
        int responseCode;
        HttpResponse response = context.getResponse();
        if (this.getHttpCallback() != null) {
            this.getHttpCallback().onAfterResponse(context);
        }
        if ((responseCode = response.getStatusCode()) == 400) {
            throw new ErrorWithRequestException("If there is any issue with values passed in by the user", context);
        }
        if (responseCode == 401) {
            throw new UnauthorizedRequestException("Authentication is either incorrect or not present", context);
        }
        if (responseCode == 403) {
            throw new ForbiddenRequestException("The user is not authorized to access this resource", context);
        }
        if (responseCode == 429) {
            throw new ErrorWithRequestException("The user has made too many bad requests and is temporarily locked out", context);
        }
        if (responseCode == 500) {
            throw new ErrorWithRequestException("An internal server error occurred", context);
        }
        this.validateResponse(response, context);
        String responseBody = ((HttpStringResponse)response).getBody();
        TwoFactorVerifyCodeResponse result = ApiHelper.deserialize(responseBody, TwoFactorVerifyCodeResponse.class);
        return new ApiResponse<TwoFactorVerifyCodeResponse>(response.getStatusCode(), response.getHeaders(), result);
    }
}

