/*
 * Decompiled with CFR 0.152.
 */
package com.bandwidth.multifactorauth.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class TwoFactorVerifyRequestSchema {
    private String to;
    private String applicationId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String scope;
    private double expirationTimeInMinutes;
    private String code;

    public TwoFactorVerifyRequestSchema() {
    }

    public TwoFactorVerifyRequestSchema(String to, String applicationId, double expirationTimeInMinutes, String code, String scope) {
        this.to = to;
        this.applicationId = applicationId;
        this.scope = scope;
        this.expirationTimeInMinutes = expirationTimeInMinutes;
        this.code = code;
    }

    @JsonGetter(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonSetter(value="to")
    public void setTo(String to) {
        this.to = to;
    }

    @JsonGetter(value="applicationId")
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonSetter(value="applicationId")
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @JsonGetter(value="scope")
    public String getScope() {
        return this.scope;
    }

    @JsonSetter(value="scope")
    public void setScope(String scope) {
        this.scope = scope;
    }

    @JsonGetter(value="expirationTimeInMinutes")
    public double getExpirationTimeInMinutes() {
        return this.expirationTimeInMinutes;
    }

    @JsonSetter(value="expirationTimeInMinutes")
    public void setExpirationTimeInMinutes(double expirationTimeInMinutes) {
        this.expirationTimeInMinutes = expirationTimeInMinutes;
    }

    @JsonGetter(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonSetter(value="code")
    public void setCode(String code) {
        this.code = code;
    }

    public String toString() {
        return "TwoFactorVerifyRequestSchema [to=" + this.to + ", applicationId=" + this.applicationId + ", expirationTimeInMinutes=" + this.expirationTimeInMinutes + ", code=" + this.code + ", scope=" + this.scope + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.to, this.applicationId, this.expirationTimeInMinutes, this.code).scope(this.getScope());
        return builder;
    }

    public static class Builder {
        private String to;
        private String applicationId;
        private double expirationTimeInMinutes;
        private String code;
        private String scope;

        public Builder() {
        }

        public Builder(String to, String applicationId, double expirationTimeInMinutes, String code) {
            this.to = to;
            this.applicationId = applicationId;
            this.expirationTimeInMinutes = expirationTimeInMinutes;
            this.code = code;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder expirationTimeInMinutes(double expirationTimeInMinutes) {
            this.expirationTimeInMinutes = expirationTimeInMinutes;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public TwoFactorVerifyRequestSchema build() {
            return new TwoFactorVerifyRequestSchema(this.to, this.applicationId, this.expirationTimeInMinutes, this.code, this.scope);
        }
    }
}

